/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.DimensionsProvider;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.mpp.bean.points.PointsBean;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitter;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.spatial.point.Point3f;

public class PointsFitterToMark
extends PointsBean<PointsFitterToMark> {
    @BeanField
    private PointsFitter pointsFitter;
    @BeanField
    private DimensionsProvider dimensions;
    @BeanField
    @Positive
    private int minNumPoints = 1;
    @BeanField
    private ObjectCollectionProvider objects;

    public void fitPointsToMark(List<Point3f> pointsForFitter, Mark mark, Dimensions dim) throws OperationFailedException {
        try {
            this.pointsFitter.fit(pointsForFitter, mark, dim);
        }
        catch (InsufficientPointsException | PointsFitterException e) {
            throw new OperationFailedException(e);
        }
    }

    public ObjectCollection createObjects() throws ProvisionFailedException {
        return (ObjectCollection)this.objects.get();
    }

    public Dimensions createDim() throws ProvisionFailedException {
        return (Dimensions)this.dimensions.get();
    }

    @Generated
    public PointsFitter getPointsFitter() {
        return this.pointsFitter;
    }

    @Generated
    public void setPointsFitter(PointsFitter pointsFitter) {
        this.pointsFitter = pointsFitter;
    }

    @Generated
    public DimensionsProvider getDimensions() {
        return this.dimensions;
    }

    @Generated
    public void setDimensions(DimensionsProvider dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public int getMinNumPoints() {
        return this.minNumPoints;
    }

    @Generated
    public void setMinNumPoints(int minNumPoints) {
        this.minNumPoints = minNumPoints;
    }

    @Generated
    public ObjectCollectionProvider getObjects() {
        return this.objects;
    }

    @Generated
    public void setObjects(ObjectCollectionProvider objects) {
        this.objects = objects;
    }
}

