/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.NonNegative;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitter;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3f;

public class ReflectInAxesWithinDistance
extends PointsFitter {
    @BeanField
    private PointsFitter pointsFitter;
    @BeanField
    @NonNegative
    private double distanceX = -1.0;
    @BeanField
    @NonNegative
    private double distanceY = -1.0;
    @BeanField
    @NonNegative
    private double distanceZ = -1.0;

    public boolean isCompatibleWith(Mark testMark) {
        return this.pointsFitter.isCompatibleWith(testMark);
    }

    public void fit(List<Point3f> points, Mark mark, Dimensions dimensions) throws PointsFitterException, InsufficientPointsException {
        if (points.isEmpty()) {
            this.pointsFitter.fit(points, mark, dimensions);
        }
        double[] arrDistances = new double[]{this.distanceX, this.distanceY, this.distanceZ};
        List<Point3f> pointsCurrent = points;
        Extent extent = dimensions.extent();
        block0: for (int dimension = 0; dimension < 3; ++dimension) {
            for (int side = 0; side < 1; ++side) {
                if (!ReflectInAxesWithinDistance.arePointsWithinDistanceOfBorder(points, extent, dimension, side == 0, arrDistances)) continue;
                pointsCurrent = ReflectInAxesWithinDistance.reflectInDimension(pointsCurrent, extent, dimension, side == 0);
                continue block0;
            }
        }
        this.pointsFitter.fit(pointsCurrent, mark, dimensions);
    }

    private static List<Point3f> reflectInDimension(List<Point3f> pointsIn, Extent extent, int dimension, boolean min) {
        return FunctionalList.flatMapToList(pointsIn, point -> Stream.of(point, ReflectInAxesWithinDistance.reflectPoint(point, extent, dimension, min)));
    }

    private static Point3f reflectPoint(Point3f point, Extent extent, int dimension, boolean min) {
        Point3f pointReflected = new Point3f(point);
        pointReflected.setValueByDimension(dimension, ReflectInAxesWithinDistance.reflectedValue(point, extent, dimension, min));
        return pointReflected;
    }

    private static float reflectedValue(Point3f point, Extent extent, int dimension, boolean min) {
        float unreflectedValue = point.valueByDimension(dimension);
        if (min) {
            return unreflectedValue * -1.0f;
        }
        float extentInDimension = extent.valueByDimension(dimension);
        return 2.0f * extentInDimension - unreflectedValue;
    }

    private static boolean arePointsWithinDistanceOfBorder(List<Point3f> points, Extent extent, int dimension, boolean min, double[] arrDistances) {
        double dimensionMax = extent.valueByDimension(dimension);
        double maxAllowedDistance = arrDistances[dimension];
        for (Point3f point : points) {
            double valueForDimension = point.valueByDimension(dimension);
            double d = min ? valueForDimension : dimensionMax - valueForDimension;
            double distance = d;
            if (!(distance > maxAllowedDistance)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public PointsFitter getPointsFitter() {
        return this.pointsFitter;
    }

    @Generated
    public void setPointsFitter(PointsFitter pointsFitter) {
        this.pointsFitter = pointsFitter;
    }

    @Generated
    public double getDistanceX() {
        return this.distanceX;
    }

    @Generated
    public void setDistanceX(double distanceX) {
        this.distanceX = distanceX;
    }

    @Generated
    public double getDistanceY() {
        return this.distanceY;
    }

    @Generated
    public void setDistanceY(double distanceY) {
        this.distanceY = distanceY;
    }

    @Generated
    public double getDistanceZ() {
        return this.distanceZ;
    }

    @Generated
    public void setDistanceZ(double distanceZ) {
        this.distanceZ = distanceZ;
    }
}

