/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.calculate.ellipse;

import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.mark.conic.Ellipse;
import org.anchoranalysis.plugin.points.bean.fitter.LinearLeastSquaresEllipseFitter;
import org.anchoranalysis.plugin.points.calculate.ellipse.EllipseFactory;
import org.anchoranalysis.plugin.points.calculate.ellipse.ObjectWithEllipse;

public class CalculateEllipseLeastSquares
extends CalculationPart<ObjectWithEllipse, FeatureInputSingleObject> {
    private EllipseFactory factory = new EllipseFactory(new LinearLeastSquaresEllipseFitter());

    protected ObjectWithEllipse execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        try {
            EnergyStackWithoutParameters energyStack = input.getEnergyStackRequired().withoutParameters();
            ObjectMask object = CalculateEllipseLeastSquares.extractEllipseSlice(input.getObject());
            Ellipse mark = this.factory.create(object, energyStack.dimensions(), 0.2);
            return new ObjectWithEllipse(object, mark);
        }
        catch (CreateException | InsufficientPointsException e) {
            throw new FeatureCalculationException(e);
        }
    }

    private static ObjectMask extractEllipseSlice(ObjectMask object) {
        int zSliceCenter = (int)object.centerOfGravity().z();
        return object.extractSlice(zSliceCenter, false);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateEllipseLeastSquares)) {
            return false;
        }
        CalculateEllipseLeastSquares other = (CalculateEllipseLeastSquares)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateEllipseLeastSquares;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

