/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.spatial.box.BoundingBoxContains;
import org.anchoranalysis.spatial.box.BoundingBoxIntersection;
import org.anchoranalysis.spatial.box.BoundingBoxUnion;
import org.anchoranalysis.spatial.box.ClampToUtilities;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.Tuple3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;
import org.anchoranalysis.spatial.scale.Scaler;

public final class BoundingBox
implements Serializable,
Comparable<BoundingBox> {
    private static final long serialVersionUID = 1L;
    private final Point3i cornerMin;
    private Point3i cornerMaxInclusive;
    private Point3i cornerMaxExclusive;
    private final Extent extent;

    public BoundingBox(Extent extent) {
        this(Point3i.ORIGIN, extent);
    }

    private BoundingBox(ReadableTuple3i cornerMin, Extent extent) {
        this.cornerMin = new Point3i(cornerMin);
        this.extent = extent;
    }

    public static BoundingBox createReuse(ReadableTuple3i cornerMin, Extent extent) {
        return new BoundingBox(cornerMin, extent);
    }

    public static BoundingBox createDuplicate(ReadableTuple3i cornerMin, Extent extent) {
        return new BoundingBox(new Point3i(cornerMin), extent);
    }

    public static BoundingBox createReuse(ReadableTuple3i cornerMinInclusive, ReadableTuple3i cornerMaxInclusive) {
        BoundingBox box = new BoundingBox(cornerMinInclusive, new Extent(cornerMaxInclusive.x() - cornerMinInclusive.x() + 1, cornerMaxInclusive.y() - cornerMinInclusive.y() + 1, cornerMaxInclusive.z() - cornerMinInclusive.z() + 1));
        BoundingBox.checkMaxMoreThanMin(cornerMinInclusive, cornerMaxInclusive);
        return box;
    }

    public static BoundingBox createDuplicate(ReadableTuple3i cornerMinInclusive, ReadableTuple3i cornerMaxInclusive) {
        return BoundingBox.createReuse((ReadableTuple3i)new Point3i(cornerMinInclusive), cornerMaxInclusive);
    }

    public static BoundingBox createReuse(Point3d cornerMinInclusive, Point3d cornerMaxInclusive) {
        return BoundingBox.createReuse((ReadableTuple3i)PointConverter.intFromDoubleFloor(cornerMinInclusive), PointConverter.intFromDoubleCeil(cornerMaxInclusive));
    }

    public Point3d midpoint() {
        return this.meanOfExtent(0);
    }

    public Point3i centerOfGravity() {
        return PointConverter.intFromDoubleFloor(this.meanOfExtent(1));
    }

    public BoundingBox flattenZ() {
        return BoundingBox.createReuse((ReadableTuple3i)this.cornerMin.duplicateChangeZ(0), this.extent.duplicateChangeZ(1));
    }

    public BoundingBox changeExtent(Extent extent) {
        return BoundingBox.createReuse((ReadableTuple3i)this.cornerMin, extent);
    }

    public BoundingBox changeExtent(UnaryOperator<Extent> extentOperator) {
        return this.changeExtent((Extent)extentOperator.apply(this.extent));
    }

    public BoundingBox changeZ(int cornerZ, int extentZ) {
        return BoundingBox.createReuse((ReadableTuple3i)this.cornerMin.duplicateChangeZ(cornerZ), this.extent.duplicateChangeZ(extentZ));
    }

    public BoundingBox changeExtentZ(int extentZ) {
        return BoundingBox.createReuse((ReadableTuple3i)this.cornerMin, this.extent.duplicateChangeZ(extentZ));
    }

    public boolean atBorder(Extent extent) {
        if (this.atBorderXY(extent)) {
            return true;
        }
        return this.atBorderZ(extent);
    }

    public boolean atBorderXY(Extent extent) {
        ReadableTuple3i cornerMax = this.calculateCornerMaxExclusive();
        if (this.cornerMin.x() == 0) {
            return true;
        }
        if (this.cornerMin.y() == 0) {
            return true;
        }
        if (cornerMax.x() == extent.x()) {
            return true;
        }
        return cornerMax.y() == extent.y();
    }

    public boolean atBorderZ(Extent extent) {
        ReadableTuple3i cornerMax = this.calculateCornerMaxExclusive();
        if (this.cornerMin.z() == 0) {
            return true;
        }
        return cornerMax.z() == extent.z();
    }

    public BoundingBox growBy(Tuple3i toAdd, Extent containingExtent) {
        Preconditions.checkArgument((toAdd.x() >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((toAdd.y() >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((toAdd.z() >= 0 ? 1 : 0) != 0);
        Point3i cornerMinShifted = Point3i.immutableSubtract(this.cornerMin, toAdd);
        Extent extentGrown = this.extent.growBy(BoundingBox.multiplyByTwo(toAdd));
        return BoundingBox.createReuse((ReadableTuple3i)cornerMinShifted, extentGrown).clampTo(containingExtent);
    }

    public ReadableTuple3i cornerMin() {
        return this.cornerMin;
    }

    public ReadableTuple3i calculateCornerMaxInclusive() {
        if (this.cornerMaxInclusive == null) {
            this.cornerMaxInclusive = new Point3i(this.cornerMin.x() + this.extent.x() - 1, this.cornerMin.y() + this.extent.y() - 1, this.cornerMin.z() + this.extent.z() - 1);
        }
        return this.cornerMaxInclusive;
    }

    public ReadableTuple3i calculateCornerMaxExclusive() {
        if (this.cornerMaxExclusive == null) {
            this.cornerMaxExclusive = new Point3i(this.cornerMin.x() + this.extent.x(), this.cornerMin.y() + this.extent.y(), this.cornerMin.z() + this.extent.z());
        }
        return this.cornerMaxExclusive;
    }

    public BoundingBox clampTo(Extent extent) {
        if (this.cornerMin.x() >= extent.x() || this.cornerMin.y() >= extent.y() || this.cornerMin.z() >= extent.z()) {
            throw new AnchorFriendlyRuntimeException(String.format("Corner-min (%s) is outside the clamping region (%s)", this.cornerMin, extent));
        }
        ReadableTuple3i cornerMax = this.calculateCornerMaxInclusive();
        boolean cornerMinValid = ClampToUtilities.pointNonZero(this.cornerMin);
        boolean cornerMaxValid = ClampToUtilities.pointLessThan(cornerMax, extent);
        if (cornerMinValid && cornerMaxValid) {
            return this;
        }
        Point3i min = cornerMinValid ? this.cornerMin : ClampToUtilities.replaceNegativeWithZero(this.cornerMin);
        ReadableTuple3i max = cornerMaxValid ? cornerMax : ClampToUtilities.limitToExtent(cornerMax, extent);
        return BoundingBox.createReuse((ReadableTuple3i)min, max);
    }

    public Point3i relativePositionTo(BoundingBox other) {
        return Point3i.immutableSubtract(this.cornerMin, other.cornerMin);
    }

    public BoundingBox relativePositionToBox(BoundingBox other) {
        return BoundingBox.createReuse((ReadableTuple3i)this.relativePositionTo(other), this.extent);
    }

    public BoundingBoxContains contains() {
        return new BoundingBoxContains(this);
    }

    public BoundingBoxIntersection intersection() {
        return new BoundingBoxIntersection(this);
    }

    public BoundingBoxUnion union() {
        return new BoundingBoxUnion(this);
    }

    public String toString() {
        return this.cornerMin.toString() + "+" + this.extent.toString() + "=" + this.calculateCornerMaxExclusive().toString();
    }

    public BoundingBox shiftToOrigin() {
        return new BoundingBox(this.extent);
    }

    public BoundingBox shiftBy(ReadableTuple3i shift) {
        return BoundingBox.createReuse((ReadableTuple3i)Point3i.immutableAdd(this.cornerMin, shift), this.extent);
    }

    public BoundingBox shiftBackBy(ReadableTuple3i shift) {
        return BoundingBox.createReuse((ReadableTuple3i)Point3i.immutableSubtract(this.cornerMin, shift), this.extent);
    }

    public BoundingBox shiftTo(ReadableTuple3i cornerMinToAssign) {
        return BoundingBox.createReuse(cornerMinToAssign, this.extent);
    }

    public BoundingBox shiftToZ(int cornerZToAssign) {
        return BoundingBox.createReuse((ReadableTuple3i)this.cornerMin.duplicateChangeZ(cornerZToAssign), this.extent);
    }

    public BoundingBox reflectThroughOrigin() {
        return BoundingBox.createReuse((ReadableTuple3i)Point3i.immutableScale(this.cornerMin, -1), this.extent);
    }

    public BoundingBox scale(ScaleFactor scaleFactor) {
        return this.scale(scaleFactor, this.scaledExtent(scaleFactor));
    }

    public BoundingBox scaleClampTo(ScaleFactor scaleFactor, Extent clampTo) {
        Point3i cornerScaled = this.scaledCorner(scaleFactor);
        Extent extentScaled = this.scaledExtent(scaleFactor);
        BoundingBox boxScaled = BoundingBox.createReuse((ReadableTuple3i)cornerScaled, extentScaled);
        return boxScaled.clampTo(clampTo);
    }

    public BoundingBox scale(ScaleFactor scaleFactor, Extent extentToAssign) {
        return BoundingBox.createReuse((ReadableTuple3i)this.scaledCorner(scaleFactor), extentToAssign);
    }

    @Override
    public int compareTo(BoundingBox other) {
        int compareCornerMin = this.cornerMin.compareTo(other.cornerMin);
        if (compareCornerMin != 0) {
            return compareCornerMin;
        }
        int compareExtent = this.extent.compareTo(other.extent);
        if (compareExtent != 0) {
            return compareExtent;
        }
        return 0;
    }

    private Extent scaledExtent(ScaleFactor scaleFactor) {
        return this.extent.scaleXYBy(scaleFactor, true);
    }

    private Point3i scaledCorner(ScaleFactor scaleFactor) {
        return Scaler.scale(scaleFactor, this.cornerMin);
    }

    private Point3d meanOfExtent(int subtractFromEachDimension) {
        return new Point3d(this.calculateMeanForDim(ReadableTuple3i::x, subtractFromEachDimension), this.calculateMeanForDim(ReadableTuple3i::y, subtractFromEachDimension), this.calculateMeanForDim(ReadableTuple3i::z, subtractFromEachDimension));
    }

    private double calculateMeanForDim(ToDoubleFunction<ReadableTuple3i> extractDim, int subtractFromEachDimension) {
        double midPointInExtent = (extractDim.applyAsDouble(this.extent.asTuple()) - (double)subtractFromEachDimension) / 2.0;
        return extractDim.applyAsDouble(this.cornerMin) + midPointInExtent;
    }

    private static void checkMaxMoreThanMin(ReadableTuple3i min, ReadableTuple3i max) {
        if (max.x() < min.x() || max.y() < min.y() || max.z() < min.z()) {
            throw new AnchorFriendlyRuntimeException(String.format("To create a bounding-box, the max-point %s must always be >= the min-point %s in all dimensions.", max, min));
        }
    }

    private static Point3i multiplyByTwo(Tuple3i point) {
        return Point3i.immutableScale(point, 2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)o;
        ReadableTuple3i this$cornerMin = this.cornerMin();
        ReadableTuple3i other$cornerMin = other.cornerMin();
        if (this$cornerMin == null ? other$cornerMin != null : !this$cornerMin.equals(other$cornerMin)) {
            return false;
        }
        Point3i this$cornerMaxInclusive = this.cornerMaxInclusive;
        Point3i other$cornerMaxInclusive = other.cornerMaxInclusive;
        if (this$cornerMaxInclusive == null ? other$cornerMaxInclusive != null : !((Object)this$cornerMaxInclusive).equals(other$cornerMaxInclusive)) {
            return false;
        }
        Extent this$extent = this.extent();
        Extent other$extent = other.extent();
        return !(this$extent == null ? other$extent != null : !((Object)this$extent).equals(other$extent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReadableTuple3i $cornerMin = this.cornerMin();
        result = result * 59 + ($cornerMin == null ? 43 : $cornerMin.hashCode());
        Point3i $cornerMaxInclusive = this.cornerMaxInclusive;
        result = result * 59 + ($cornerMaxInclusive == null ? 43 : ((Object)$cornerMaxInclusive).hashCode());
        Extent $extent = this.extent();
        result = result * 59 + ($extent == null ? 43 : ((Object)$extent).hashCode());
        return result;
    }

    public Extent extent() {
        return this.extent;
    }
}

