/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.box.ExtentBoundsComparer;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public final class BoundingBoxIntersection {
    private final BoundingBox box;

    public boolean existsWith(BoundingBox other) {
        return this.with(other, false).isPresent();
    }

    public boolean existsWithAny(List<BoundingBox> others) {
        for (BoundingBox other : others) {
            if (!this.existsWith(other)) continue;
            return true;
        }
        return false;
    }

    public Optional<BoundingBox> with(BoundingBox other) {
        return this.with(other, true);
    }

    public Optional<BoundingBox> withInside(BoundingBox other, Extent containingExtent) {
        return this.with(other).map(boundingBox -> boundingBox.clampTo(containingExtent));
    }

    private Optional<BoundingBox> with(BoundingBox other, boolean createIntersectionBox) {
        CreateComparer createComparer = new CreateComparer(this.box, other);
        Optional<ExtentBoundsComparer> compareX = createComparer.createMin(ReadableTuple3i::x);
        Optional<ExtentBoundsComparer> compareY = createComparer.createMin(ReadableTuple3i::y);
        Optional<ExtentBoundsComparer> compareZ = createComparer.createMin(ReadableTuple3i::z);
        if (!(compareX.isPresent() && compareY.isPresent() && compareZ.isPresent())) {
            return Optional.empty();
        }
        if (createIntersectionBox) {
            return Optional.of(this.createIntersection(compareX.get(), compareY.get(), compareZ.get()));
        }
        return Optional.of(this.box);
    }

    private BoundingBox createIntersection(ExtentBoundsComparer compareX, ExtentBoundsComparer compareY, ExtentBoundsComparer compareZ) {
        return BoundingBox.createReuse((ReadableTuple3i)new Point3i(compareX.min(), compareY.min(), compareZ.min()), new Extent(compareX.extent(), compareY.extent(), compareZ.extent()));
    }

    public BoundingBoxIntersection(BoundingBox box) {
        this.box = box;
    }

    private static class CreateComparer {
        private final ReadableTuple3i cornerMin1;
        private final ReadableTuple3i cornerMin2;
        private final ReadableTuple3i cornerMax1;
        private final ReadableTuple3i cornerMax2;

        public CreateComparer(BoundingBox box1, BoundingBox box2) {
            this.cornerMin1 = box1.cornerMin();
            this.cornerMin2 = box2.cornerMin();
            this.cornerMax1 = box1.calculateCornerMaxInclusive();
            this.cornerMax2 = box2.calculateCornerMaxInclusive();
        }

        public Optional<ExtentBoundsComparer> createMin(ToIntFunction<ReadableTuple3i> extract) {
            return ExtentBoundsComparer.createMin(this.cornerMin1, this.cornerMin2, this.cornerMax1, this.cornerMax2, extract);
        }
    }
}

