/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import java.util.Optional;
import java.util.function.IntBinaryOperator;
import java.util.function.ToIntFunction;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

final class ExtentBoundsComparer {
    private final int min;
    private final int max;

    public int extent() {
        return this.max - this.min + 1;
    }

    public static ExtentBoundsComparer createMax(ReadableTuple3i min1, ReadableTuple3i min2, ReadableTuple3i max1, ReadableTuple3i max2, ToIntFunction<ReadableTuple3i> extract) {
        return ExtentBoundsComparer.calculate(extract.applyAsInt(min1), extract.applyAsInt(min2), extract.applyAsInt(max1), extract.applyAsInt(max2), Math::min, Math::max).orElseThrow(AnchorImpossibleSituationException::new);
    }

    public static Optional<ExtentBoundsComparer> createMin(ReadableTuple3i min1, ReadableTuple3i min2, ReadableTuple3i max1, ReadableTuple3i max2, ToIntFunction<ReadableTuple3i> extract) {
        return ExtentBoundsComparer.calculate(extract.applyAsInt(min1), extract.applyAsInt(min2), extract.applyAsInt(max1), extract.applyAsInt(max2), Math::max, Math::min);
    }

    private static Optional<ExtentBoundsComparer> calculate(int min1, int min2, int max1, int max2, IntBinaryOperator minOperator, IntBinaryOperator maxOperator) {
        int maxNew;
        int minNew = minOperator.applyAsInt(min1, min2);
        if (minNew <= (maxNew = maxOperator.applyAsInt(max1, max2))) {
            return Optional.of(new ExtentBoundsComparer(minNew, maxNew));
        }
        return Optional.empty();
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtentBoundsComparer)) {
            return false;
        }
        ExtentBoundsComparer other = (ExtentBoundsComparer)o;
        if (this.min() != other.min()) {
            return false;
        }
        return this.max() == other.max();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.min();
        result = result * 59 + this.max();
        return result;
    }

    public String toString() {
        return "ExtentBoundsComparer(min=" + this.min() + ", max=" + this.max() + ")";
    }

    private ExtentBoundsComparer(int min, int max) {
        this.min = min;
        this.max = max;
    }
}

