/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import java.util.Optional;
import org.anchoranalysis.spatial.box.BoundingBox;

public class IntersectionOverUnion {
    public static double forBoxes(BoundingBox box1, BoundingBox box2) {
        Optional<BoundingBox> intersection = box1.intersection().with(box2);
        if (!intersection.isPresent()) {
            return 0.0;
        }
        long intersectionArea = intersection.get().extent().calculateVolume();
        long total = box2.extent().calculateVolume() + box1.extent().calculateVolume() - intersectionArea;
        return (double)intersectionArea / (double)total;
    }

    private IntersectionOverUnion() {
    }
}

