/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import java.util.List;
import org.anchoranalysis.spatial.point.Point3i;

public class PointsNeighborChecker {
    public static boolean areAllPointsInBigNeighborhood(List<Point3i> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point3i second;
            Point3i first;
            if (i == 0 || PointsNeighborChecker.arePointsNeighbors(first = list.get(i - 1), second = list.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean arePointsNeighbors(Point3i point1, Point3i point2) {
        if (point1.equals(point2)) {
            return false;
        }
        if (PointsNeighborChecker.distanceSingleDim(point1.x(), point2.x())) {
            return false;
        }
        if (PointsNeighborChecker.distanceSingleDim(point1.y(), point2.y())) {
            return false;
        }
        return !PointsNeighborChecker.distanceSingleDim(point1.z(), point2.z());
    }

    private static boolean distanceSingleDim(int x, int y) {
        return Math.abs(x - y) > 1;
    }

    private PointsNeighborChecker() {
    }
}

