/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public abstract class Tuple3i
implements ReadableTuple3i {
    private static final long serialVersionUID = 1L;
    protected int x = 0;
    protected int y = 0;
    protected int z = 0;

    public final void add(ReadableTuple3i toAdd) {
        this.x += toAdd.x();
        this.y += toAdd.y();
        this.z += toAdd.z();
    }

    public final void subtract(int valueToSubtract) {
        this.x -= valueToSubtract;
        this.y -= valueToSubtract;
        this.z -= valueToSubtract;
    }

    public final void subtract(ReadableTuple3i valueToSubtract) {
        this.x -= valueToSubtract.x();
        this.y -= valueToSubtract.y();
        this.z -= valueToSubtract.z();
    }

    public final void scale(int factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    public final void scale(double factor) {
        this.scaleXY(factor);
        this.z = (int)(factor * (double)this.z);
    }

    public final void divideBy(int divisor) {
        this.x /= divisor;
        this.y /= divisor;
        this.z /= divisor;
    }

    public final void scaleX(double factor) {
        this.x = (int)(factor * (double)this.x);
    }

    public final void scaleY(double factor) {
        this.y = (int)(factor * (double)this.y);
    }

    public final void scaleXY(double factor) {
        this.scaleX(factor);
        this.scaleY(factor);
    }

    public Point3i min(ReadableTuple3i point) {
        return new Point3i(Math.min(this.x, point.x()), Math.min(this.y, point.y()), Math.min(this.z, point.z()));
    }

    public Point3i max(ReadableTuple3i point) {
        return new Point3i(Math.max(this.x, point.x()), Math.max(this.y, point.y()), Math.max(this.z, point.z()));
    }

    public Point3i max(int value) {
        return new Point3i(Math.max(this.x, value), Math.max(this.y, value), Math.max(this.z, value));
    }

    @Override
    public final int valueByDimension(int dimensionIndex) {
        if (dimensionIndex == 0) {
            return this.x;
        }
        if (dimensionIndex == 1) {
            return this.y;
        }
        if (dimensionIndex == 2) {
            return this.z;
        }
        throw new AnchorFriendlyRuntimeException("axis must be: x or y or z");
    }

    @Override
    public final int valueByDimension(Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        throw new AnchorFriendlyRuntimeException("the index for axis must be: 0 or 1 or 2");
    }

    public final void incrementX() {
        ++this.x;
    }

    public final void incrementY() {
        ++this.y;
    }

    public final void incrementZ() {
        ++this.z;
    }

    public final void incrementX(int shift) {
        this.x += shift;
    }

    public final void incrementY(int shift) {
        this.y += shift;
    }

    public final void incrementZ(int shift) {
        this.z += shift;
    }

    public final void decrementX() {
        --this.x;
    }

    public final void decrementY() {
        --this.y;
    }

    public final void decrementZ() {
        --this.z;
    }

    public final void decrementX(int shift) {
        this.x -= shift;
    }

    public final void decrementY(int shift) {
        this.y -= shift;
    }

    public final void decrementZ(int shift) {
        this.z -= shift;
    }

    public String toString() {
        return String.format("[%d,%d,%d]", this.x, this.y, this.z);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tuple3i)) {
            return false;
        }
        Tuple3i other = (Tuple3i)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tuple3i;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.x;
        result = result * 59 + this.y;
        result = result * 59 + this.z;
        return result;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }
}

