/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.rtree;

import com.github.davidmoten.rtreemulti.geometry.Point;
import com.github.davidmoten.rtreemulti.geometry.Rectangle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.rtree.RTree;

public class BoundingBoxRTree<T>
extends RTree<T> {
    private static final int NUMBER_DIMENSIONS = 3;

    public BoundingBoxRTree() {
        super(3);
    }

    public BoundingBoxRTree(int maxNumberEntries) {
        super(3, maxNumberEntries);
    }

    public Set<T> contains(ReadableTuple3i point) {
        return this.containsStream(point).collect(Collectors.toSet());
    }

    public Stream<T> containsStream(ReadableTuple3i point) {
        Point pointToSearch = Point.create((double[])new double[]{point.x(), point.y(), point.z()});
        return super.containsStream(pointToSearch);
    }

    public void add(BoundingBox box, T payload) {
        super.add(BoundingBoxRTree.asRectangle(box), payload);
    }

    public Set<T> intersectsWith(BoundingBox toIntersectWith) {
        return this.intersectsWithStream(toIntersectWith).collect(Collectors.toSet());
    }

    public Stream<T> intersectsWithStream(BoundingBox toIntersectWith) {
        return super.intersectsWithStream(BoundingBoxRTree.asRectangle(toIntersectWith));
    }

    public void remove(BoundingBox box, T payload) {
        super.remove(BoundingBoxRTree.asRectangle(box), payload);
    }

    private static Rectangle asRectangle(BoundingBox box) {
        return Rectangle.create((double[])BoundingBoxRTree.minPoint(box), (double[])BoundingBoxRTree.maxPoint(box));
    }

    private static double[] minPoint(BoundingBox box) {
        return new double[]{box.cornerMin().x(), box.cornerMin().y(), box.cornerMin().z()};
    }

    private static double[] maxPoint(BoundingBox box) {
        ReadableTuple3i max = box.calculateCornerMaxInclusive();
        return new double[]{max.x(), max.y(), max.z()};
    }
}

