/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.core.functional.checked.CheckedIntConsumer;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point2i;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.consumer.OffsettedPointTwoDimensionalConsumer;
import org.anchoranalysis.spatial.point.consumer.OffsettedScalarTwoDimensionalConsumer;
import org.anchoranalysis.spatial.point.consumer.PointTwoDimensionalConsumer;
import org.anchoranalysis.spatial.scale.ScaleFactor;
import org.anchoranalysis.spatial.scale.Scaler;

public final class Extent
implements Serializable,
Comparable<Extent> {
    private static final long serialVersionUID = 1L;
    private final ReadableTuple3i size;
    private final int areaXY;

    public Extent(int x, int y) {
        this(x, y, 1);
    }

    public Extent(int x, int y, int z) {
        this(new Point3i(x, y, z));
    }

    public static Extent createFromTupleDuplicate(ReadableTuple3i tuple) {
        return new Extent(new Point3i(tuple));
    }

    public static Extent createFromTupleReuse(ReadableTuple3i tuple) {
        return new Extent(new Point3i(tuple));
    }

    private Extent(ReadableTuple3i size) {
        this.size = size;
        this.areaXY = this.calculateAreaXY();
        if (size.x() == 0 || size.y() == 0 || size.z() == 0) {
            throw new AnchorFriendlyRuntimeException("An extent must have at least one voxel in every dimension.");
        }
        if (size.x() < 0 || size.y() < 0 || size.z() < 0) {
            throw new AnchorFriendlyRuntimeException("An extent may not be negative in any dimension");
        }
    }

    public int areaXY() {
        return this.areaXYAsInt();
    }

    public double calculateAreaXYAsDouble() {
        return (double)this.size.x() * (double)this.size.y();
    }

    public long calculateVolume() {
        if (this.areaXY >= 0) {
            return (long)this.areaXY * (long)this.size.z();
        }
        return (long)this.size.x() * (long)this.size.y() * (long)this.size.z();
    }

    public int calculateVolumeAsInt() {
        long volume = this.calculateVolume();
        if (volume > Integer.MAX_VALUE) {
            throw new AnchorFriendlyRuntimeException("The volume cannot be expressed as an int, as it is higher than the maximum bound");
        }
        return (int)volume;
    }

    public boolean isEmpty() {
        return this.areaXY == 0 || this.size.z() == 0;
    }

    public int x() {
        return this.size.x();
    }

    public int y() {
        return this.size.y();
    }

    public int z() {
        return this.size.z();
    }

    public int valueByDimension(int dimensionIndex) {
        return this.size.valueByDimension(dimensionIndex);
    }

    public int valueByDimension(Axis axis) {
        return this.size.valueByDimension(axis);
    }

    public ReadableTuple3i asTuple() {
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.size.x();
        result = 31 * result + this.size.y();
        result = 31 * result + this.size.z();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Extent other = (Extent)obj;
        return this.size.equals(other.size);
    }

    public boolean equalsIgnoreZ(Extent other) {
        return this.size.x() == other.x() && this.size.y() == other.y();
    }

    public String toString() {
        return String.format("[%d,%d,%d]", this.x(), this.y(), this.z());
    }

    public final int offset(int x, int y) {
        return y * this.size.x() + x;
    }

    public final int offset(int x, int y, int z) {
        return z * this.areaXY + y * this.x() + x;
    }

    public final int offset(ReadableTuple3i point) {
        return this.offset(point.x(), point.y(), point.z());
    }

    public final int offset(Point2i point) {
        return this.offset(point.x(), point.y(), 0);
    }

    public final int offsetSlice(ReadableTuple3i point) {
        return this.offset(point.x(), point.y(), 0);
    }

    public Extent duplicateChangeX(int xToAssign) {
        return new Extent(xToAssign, this.size.y(), this.size.z());
    }

    public Extent duplicateChangeY(int yToAssign) {
        return new Extent(this.size.x(), yToAssign, this.size.z());
    }

    public Extent duplicateChangeZ(int zToAssign) {
        return new Extent(this.size.x(), this.size.y(), zToAssign);
    }

    public boolean containsX(double value) {
        return value >= 0.0 && value < (double)this.x();
    }

    public boolean containsY(double value) {
        return value >= 0.0 && value < (double)this.y();
    }

    public boolean containsZ(double value) {
        return value >= 0.0 && value < (double)this.z();
    }

    public boolean containsX(int value) {
        return value >= 0 && value < this.x();
    }

    public boolean containsY(int value) {
        return value >= 0 && value < this.y();
    }

    public boolean containsZ(int value) {
        return value >= 0 && value < this.z();
    }

    public boolean contains(Point2i point) {
        return this.containsX(point.x()) && this.containsY(point.y());
    }

    public boolean contains(Point3d point) {
        return this.containsX(point.x()) && this.containsY(point.y()) && this.containsZ(point.z());
    }

    public boolean contains(ReadableTuple3i point) {
        return this.containsX(point.x()) && this.containsY(point.y()) && this.containsZ(point.z());
    }

    public boolean contains(int x, int y, int z) {
        if (x < 0) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (z < 0) {
            return false;
        }
        if (x >= this.size.x()) {
            return false;
        }
        if (y >= this.size.y()) {
            return false;
        }
        return z < this.size.z();
    }

    public boolean contains(BoundingBox box) {
        return this.contains(box.cornerMin()) && this.contains(box.calculateCornerMaxInclusive());
    }

    public Extent scaleXYBy(ScaleFactor scaleFactor, boolean round) {
        return new Extent(this.immutablePointOperation(point -> {
            point.setX(Scaler.scaleMultiplex(scaleFactor.x(), this.x(), round));
            point.setY(Scaler.scaleMultiplex(scaleFactor.y(), this.y(), round));
        }));
    }

    public Extent scaleXYBy(double scaleFactor, boolean round) {
        return new Extent(this.immutablePointOperation(point -> {
            point.setX(Scaler.scaleMultiplex(scaleFactor, this.x(), round));
            point.setY(Scaler.scaleMultiplex(scaleFactor, this.y(), round));
        }));
    }

    public Point3i createMinusOne() {
        return this.immutablePointOperation(p -> p.subtract(1));
    }

    public Extent growBy(int toAdd) {
        return this.growBy(new Point3i(toAdd));
    }

    public Extent growBy(ReadableTuple3i toAdd) {
        return new Extent(Point3i.immutableAdd(this.size, toAdd));
    }

    public Extent shrinkBy(ReadableTuple3i toSubtract) {
        Point3i sizeToAssign = Point3i.immutableSubtract(this.size, toSubtract);
        if (sizeToAssign.x() >= 1 && sizeToAssign.y() >= 1 && sizeToAssign.z() >= 1) {
            return new Extent(sizeToAssign);
        }
        throw new AnchorFriendlyRuntimeException(String.format("Cannot shrink by %s as it is larger than %s", toSubtract, this.size));
    }

    public Extent intersectWith(Extent other) {
        return new Extent(Point3i.elementwiseOperation(this.size, other.size, Math::min));
    }

    public Extent flattenZ() {
        return new Extent(new Point3i(this.size.x(), this.size.y(), 1));
    }

    public boolean anyDimensionIsLargerThan(Extent other) {
        if (this.x() > other.x()) {
            return true;
        }
        if (this.y() > other.y()) {
            return true;
        }
        return this.z() > other.z();
    }

    public <E extends Exception> void iterateOverXY(OffsettedScalarTwoDimensionalConsumer<E> pointConsumer) throws E {
        int offset = 0;
        for (int y = 0; y < this.size.y(); ++y) {
            for (int x = 0; x < this.size.x(); ++x) {
                pointConsumer.accept(x, y, offset++);
            }
        }
    }

    public void iterateOverXY(PointTwoDimensionalConsumer pointConsumer) {
        Point2i point = new Point2i();
        point.setY(0);
        while (point.y() < this.size.y()) {
            point.setX(0);
            while (point.x() < this.size.x()) {
                pointConsumer.accept(point);
                point.incrementX();
            }
            point.incrementY();
        }
    }

    public void iterateOverXYWithShift(Point2i shift, PointTwoDimensionalConsumer pointConsumer) {
        int maxX = this.size.x() + shift.x();
        int maxY = this.size.y() + shift.y();
        Point2i point = new Point2i();
        point.setY(shift.y());
        while (point.y() < maxY) {
            point.setX(shift.x());
            while (point.x() < maxX) {
                pointConsumer.accept(point);
                point.incrementX();
            }
            point.incrementY();
        }
    }

    public <E extends Exception> void iterateOverXYOffset(CheckedIntConsumer<E> offsetConsumer) throws E {
        int maxOffset = this.areaXYAsInt();
        for (int offset = 0; offset < maxOffset; ++offset) {
            offsetConsumer.accept(offset);
        }
    }

    public void iterateOverXYOffset(OffsettedPointTwoDimensionalConsumer pointConsumer) {
        int offset = 0;
        Point2i point = new Point2i();
        point.setY(0);
        while (point.y() < this.size.y()) {
            point.setX(0);
            while (point.x() < this.size.x()) {
                pointConsumer.accept(point, offset++);
                point.incrementX();
            }
            point.incrementY();
        }
    }

    public void iterateOverYXOffset(OffsettedPointTwoDimensionalConsumer pointConsumer) {
        int offset = 0;
        Point2i point = new Point2i();
        point.setX(0);
        while (point.x() < this.size.x()) {
            point.setY(0);
            while (point.y() < this.size.y()) {
                pointConsumer.accept(point, offset++);
                point.incrementY();
            }
            point.incrementX();
        }
    }

    public <E extends Exception> void iterateOverZ(CheckedIntConsumer<E> indexConsumer) throws E {
        for (int z = 0; z < this.size.z(); ++z) {
            indexConsumer.accept(z);
        }
    }

    public boolean iterateOverZUntil(IntPredicate indexPredicate) {
        for (int z = 0; z < this.size.z(); ++z) {
            if (indexPredicate.test(z)) continue;
            return false;
        }
        return true;
    }

    public IntStream streamOverZ() {
        return IntStream.range(0, this.size.z());
    }

    public int[] toArray() {
        return new int[]{this.x(), this.y(), this.z()};
    }

    public Extent minimum(Extent extent) {
        return new Extent(Math.min(this.x(), extent.x()), Math.min(this.y(), extent.y()), Math.min(this.z(), extent.z()));
    }

    public double aspectRatioXY() {
        return (double)this.x() / (double)this.y();
    }

    @Override
    public int compareTo(Extent other) {
        return this.size.compareTo(other.size);
    }

    private int areaXYAsInt() {
        if (this.areaXY >= 0) {
            return this.areaXY;
        }
        throw new AnchorFriendlyRuntimeException("The area is negative, which is physically impossible, and an indication that the area is too large to be stored as an int.");
    }

    private int calculateAreaXY() {
        double areaXYDouble = (double)this.size.x() * (double)this.size.y();
        if (areaXYDouble <= 2.147483647E9) {
            return this.size.x() * this.size.y();
        }
        return -1;
    }

    private Point3i immutablePointOperation(Consumer<Point3i> pointOperation) {
        Point3i sizeDuplicated = new Point3i(this.size);
        pointOperation.accept(sizeDuplicated);
        return sizeDuplicated;
    }
}

