/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.orientation;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import lombok.Generated;
import org.anchoranalysis.spatial.orientation.IndexCalculator;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.RotationMatrix;

public class Orientation3DEulerAngles
extends Orientation {
    private static final long serialVersionUID = 1L;
    private final double rotationX;
    private final double rotationY;
    private final double rotationZ;

    public String toString() {
        return String.format("%3.3f, %3.3f, %3.3f", this.rotationX, this.rotationY, this.rotationZ);
    }

    @Override
    protected RotationMatrix deriveRotationMatrix() {
        RotationMatrix rotationMatrix = new RotationMatrix(this.numberDimensions());
        DoubleMatrix2D matrix = rotationMatrix.getMatrix();
        int matNumDim = 3;
        DoubleFactory2D f = DoubleFactory2D.dense;
        DoubleMatrix2D matTemporary = f.make(3, 3);
        DoubleMatrix2D matX = f.make(3, 3);
        DoubleMatrix2D matY = f.make(3, 3);
        DoubleMatrix2D matZ = f.make(3, 3);
        Orientation3DEulerAngles.assignRotationMatrix(matX, this.rotationX, 0);
        Orientation3DEulerAngles.assignRotationMatrix(matY, this.rotationY, 1);
        Orientation3DEulerAngles.assignRotationMatrix(matZ, this.rotationZ, 2);
        matX.zMult(matY, matTemporary);
        matTemporary.zMult(matZ, matrix);
        return rotationMatrix;
    }

    @Override
    public Orientation negative() {
        return new Orientation3DEulerAngles(this.rotationX, this.rotationY, (this.rotationZ + Math.PI) % (Math.PI * 2));
    }

    @Override
    public int numberDimensions() {
        return 3;
    }

    private static void assignRotationMatrix(DoubleMatrix2D matrix, double angleRadians, int axisShift) {
        IndexCalculator index = new IndexCalculator(axisShift, 3);
        matrix.assign(0.0);
        matrix.set(index.calculate(1), index.calculate(1), Math.cos(angleRadians));
        matrix.set(index.calculate(2), index.calculate(1), Math.sin(angleRadians));
        matrix.set(index.calculate(1), index.calculate(2), -1.0 * Math.sin(angleRadians));
        matrix.set(index.calculate(2), index.calculate(2), Math.cos(angleRadians));
        matrix.set(index.calculate(0), index.calculate(0), 1.0);
    }

    @Generated
    public Orientation3DEulerAngles(double rotationX, double rotationY, double rotationZ) {
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.rotationZ = rotationZ;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Orientation3DEulerAngles)) {
            return false;
        }
        Orientation3DEulerAngles other = (Orientation3DEulerAngles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.rotationX, other.rotationX) != 0) {
            return false;
        }
        if (Double.compare(this.rotationY, other.rotationY) != 0) {
            return false;
        }
        return Double.compare(this.rotationZ, other.rotationZ) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Orientation3DEulerAngles;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rotationX = Double.doubleToLongBits(this.rotationX);
        result = result * 59 + (int)($rotationX >>> 32 ^ $rotationX);
        long $rotationY = Double.doubleToLongBits(this.rotationY);
        result = result * 59 + (int)($rotationY >>> 32 ^ $rotationY);
        long $rotationZ = Double.doubleToLongBits(this.rotationZ);
        result = result * 59 + (int)($rotationZ >>> 32 ^ $rotationZ);
        return result;
    }
}

