/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import java.io.Serializable;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public abstract class Tuple3d
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double z = 0.0;

    public final void add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public final void add(Tuple3d toAdd) {
        this.x += toAdd.x;
        this.y += toAdd.y;
        this.z += toAdd.z;
    }

    public final void add(ReadableTuple3i toAdd) {
        this.x += (double)toAdd.x();
        this.y += (double)toAdd.y();
        this.z += (double)toAdd.z();
    }

    public final void subtract(Tuple3d toSubtract) {
        this.x -= toSubtract.x;
        this.y -= toSubtract.y;
        this.z -= toSubtract.z;
    }

    public final void scale(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    public final void scaleXY(double factor) {
        this.x *= factor;
        this.y *= factor;
    }

    public final void divideBy(int divisor) {
        this.x /= (double)divisor;
        this.y /= (double)divisor;
        this.z /= (double)divisor;
    }

    public final void divideBy(double divisor) {
        this.x /= divisor;
        this.y /= divisor;
        this.z /= divisor;
    }

    public final void absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
    }

    public final void increment(Tuple3d shift) {
        this.incrementX(shift.x);
        this.incrementY(shift.y);
        this.incrementZ(shift.z);
    }

    public final void incrementX(double shift) {
        this.x += shift;
    }

    public final void incrementY(double shift) {
        this.y += shift;
    }

    public final void incrementZ(double shift) {
        this.z += shift;
    }

    public final double valueByDimension(Axis axis) {
        return switch (axis) {
            case Axis.X -> this.x;
            case Axis.Y -> this.y;
            case Axis.Z -> this.z;
            default -> throw new AnchorFriendlyRuntimeException("the index for axis must be: 0 or 1 or 2");
        };
    }

    public final double valueByDimension(int dimensionIndex) {
        return switch (dimensionIndex) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new AnchorFriendlyRuntimeException("axis must be: x or y or z");
        };
    }

    public final void setValueByDimension(int dimensionIndex, double valueToAssign) {
        switch (dimensionIndex) {
            case 0: {
                this.x = valueToAssign;
                break;
            }
            case 1: {
                this.y = valueToAssign;
                break;
            }
            case 2: {
                this.z = valueToAssign;
                break;
            }
            default: {
                throw new AnchorFriendlyRuntimeException("axis must be: x or y or z");
            }
        }
    }

    public String toString() {
        return String.format("[%5.1f,%5.1f,%5.1f]", this.x, this.y, this.z);
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final void setZ(int z) {
        this.z = z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public final double dotProduct(Tuple3d other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public double length() {
        double squared = this.x * this.x + this.y * this.y + this.z * this.z;
        return Math.sqrt(squared);
    }

    public void normalize() {
        double length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tuple3d)) {
            return false;
        }
        Tuple3d other = (Tuple3d)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.x(), other.x()) != 0) {
            return false;
        }
        if (Double.compare(this.y(), other.y()) != 0) {
            return false;
        }
        return Double.compare(this.z(), other.z()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tuple3d;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.x());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.y());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.z());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        return result;
    }

    @Generated
    public double x() {
        return this.x;
    }

    @Generated
    public double y() {
        return this.y;
    }

    @Generated
    public double z() {
        return this.z;
    }
}

