/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.experiment.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.anchoranalysis.test.TestDataInitializeException;
import org.anchoranalysis.test.TestDataLoadException;
import org.anchoranalysis.test.TestLoader;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.SystemUtils;

public class ExperimentLauncherFromShell {
    private static final String ANCHOR_COMMAND = "anchor";
    private static final String PATH_PROPERTY_IDENTIFIER = "anchor.distribution.path.test";
    private final TestLoader loader;

    public ExperimentLauncherFromShell(TestLoader loader) {
        this.loader = loader;
    }

    private String pathToAnchorExecutable() {
        String anchorCommand = SystemUtils.IS_OS_WINDOWS ? "anchor.exe" : ANCHOR_COMMAND;
        String pathProperty = System.getProperty(PATH_PROPERTY_IDENTIFIER);
        if (pathProperty == null) {
            return anchorCommand;
        }
        String pathCombined = Paths.get(pathProperty, new String[0]).resolve("bin/" + anchorCommand).toString();
        System.out.printf("Testing with path: %s (%s)%n", pathCombined, pathProperty);
        return pathCombined;
    }

    public void runExperiment(String testPathToExperiment) {
        this.runExperiment(testPathToExperiment, null, null);
    }

    private CommandLine createShellCommand(Path experimentPath, Optional<Path> inputPath, Optional<Path> outputPath) {
        CommandLine command = new CommandLine(this.pathToAnchorExecutable());
        command.addArgument(experimentPath.toString());
        if (inputPath.isPresent()) {
            command.addArgument("-input");
            command.addArgument(inputPath.get().toString());
        }
        if (outputPath.isPresent()) {
            command.addArgument("-output");
            command.addArgument(outputPath.get().toString());
        }
        return command;
    }

    public void runExperiment(String testPathToExperiment, Optional<String> testPathToInput, Optional<String> testPathToOutput) {
        CommandLine shellCmd = this.createShellCommand(this.loader.resolveTestPath(testPathToExperiment), this.resolve(testPathToInput), this.resolve(testPathToOutput));
        System.out.printf("Shell command: %s%n", shellCmd.toString());
        try {
            DefaultExecutor executor = new DefaultExecutor();
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            executor.execute(shellCmd, (ExecuteResultHandler)resultHandler);
            resultHandler.waitFor();
        }
        catch (IOException e) {
            throw new TestDataLoadException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void copyToTemporaryDirectory(File temporaryDirectory, String[] subdirectories) {
        try {
            if (subdirectories != null) {
                this.loader.copyToDirectory(subdirectories, temporaryDirectory);
            } else {
                this.loader.copyToDirectory(temporaryDirectory);
            }
        }
        catch (IOException e) {
            throw new TestDataInitializeException((Throwable)e);
        }
    }

    public TestLoader runExperimentInTemporaryDirectory(String testPathToExperiment, Path temporaryDirectory) {
        return this.runExperimentInTemporaryDirectory(testPathToExperiment, null, null, temporaryDirectory, null);
    }

    public TestLoader runExperimentInTemporaryDirectory(String testPathToExperiment, Optional<String> testPathToInput, Optional<String> testPathToOutput, Path temporaryDirectory, String[] specificSubdirectories) {
        this.copyToTemporaryDirectory(temporaryDirectory.toFile(), specificSubdirectories);
        TestLoader loaderTemporaryDirectory = TestLoader.createFromExplicitDirectory((Path)temporaryDirectory);
        ExperimentLauncherFromShell launcherTemporaryDirectory = new ExperimentLauncherFromShell(loaderTemporaryDirectory);
        launcherTemporaryDirectory.runExperiment(testPathToExperiment, testPathToInput, testPathToOutput);
        return TestLoader.createFromExplicitDirectory((Path)temporaryDirectory);
    }

    private Optional<Path> resolve(Optional<String> testPath) {
        return testPath.map(arg_0 -> ((TestLoader)this.loader).resolveTestPath(arg_0));
    }
}

