/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.experiment.task;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.OperationFailedRuntimeException;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.test.TestLoader;
import org.anchoranalysis.test.image.DualComparer;
import org.anchoranalysis.test.image.DualComparerFactory;
import org.anchoranalysis.test.image.csv.CSVComparer;
import org.junit.jupiter.api.Assertions;

class CompareHelper {
    private static final CSVComparer CSV_COMPARER = new CSVComparer(",", true, 0, true, false);

    public static void assertDirectoriesIdentical(Path absoluteOutput, String pathRelativeToResources, Iterable<String> relativePaths) throws OperationFailedException {
        CompareHelper.assertDirectoriesIdentical(absoluteOutput, pathRelativeToResources, relativePaths, false);
    }

    public static void assertDirectoriesIdentical(Path absoluteOutput, String pathRelativeToResources, Iterable<String> relativePaths, boolean copyNonIdentical) throws OperationFailedException {
        if (copyNonIdentical) {
            Path path = TestLoader.pathMavenWorkingDirectory((String)pathRelativeToResources);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        DualComparer comparer = DualComparerFactory.compareExplicitDirectoryToTest((Path)absoluteOutput, (String)pathRelativeToResources);
        for (String path : relativePaths) {
            CompareHelper.assertIdenticalFiles(comparer, path, copyNonIdentical);
        }
    }

    private static void assertIdenticalFiles(DualComparer comparer, String relativePath, boolean copyNonIdentical) throws OperationFailedException {
        if (copyNonIdentical && !comparer.getLoader2().doesPathExist(relativePath)) {
            CompareHelper.copyFromTemporaryToResources(comparer, relativePath);
            return;
        }
        boolean identical = CompareHelper.areFilesIdentical(comparer, relativePath);
        if (copyNonIdentical && !identical) {
            CompareHelper.copyFromTemporaryToResources(comparer, relativePath);
        } else {
            Assertions.assertTrue((boolean)identical, () -> relativePath + " is not identical");
        }
    }

    private static void copyFromTemporaryToResources(DualComparer comparer, String relativePath) throws OperationFailedException {
        try {
            comparer.copyFromPath1ToPath2(relativePath);
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static boolean areFilesIdentical(DualComparer comparer, String relativePath) throws OperationFailedException {
        try {
            if (ImageFileFormat.TIFF.matches(relativePath)) {
                return comparer.compareTwoImages(relativePath);
            }
            if (ImageFileFormat.PNG.matches(relativePath)) {
                return comparer.compareTwoImages(relativePath);
            }
            if (NonImageFileFormat.CSV.matches(relativePath)) {
                return comparer.compareTwoCsvFiles(relativePath, CSV_COMPARER, System.out);
            }
            if (NonImageFileFormat.XML.matches(relativePath)) {
                return comparer.compareTwoXmlDocuments(relativePath);
            }
            if (NonImageFileFormat.HDF5.matches(relativePath)) {
                return comparer.compareTwoObjectCollections(relativePath);
            }
            throw new OperationFailedRuntimeException("Extension not supported");
        }
        catch (IOException | CSVReaderException e) {
            throw new OperationFailedException(String.format("Failed to compare relativePath=%s", relativePath), e);
        }
    }

    @Generated
    private CompareHelper() {
    }
}

