/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.feature.plugins;

import java.util.Optional;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.test.LoggerFixture;
import org.junit.jupiter.api.Assertions;

public class FeatureTestCalculator {
    public static <T extends FeatureInput> void assertDoubleResult(String message, Feature<T> feature, T input, double expectedResult) throws FeatureCalculationException {
        FeatureTestCalculator.assertDoubleResult(message, feature, input, Optional.empty(), expectedResult);
    }

    public static <T extends FeatureInput> void assertIntResult(String message, Feature<T> feature, T input, int expectedResult) throws FeatureCalculationException {
        FeatureTestCalculator.assertIntResult(message, feature, input, Optional.empty(), expectedResult);
    }

    public static <T extends FeatureInput> void assertDoubleResult(String message, Feature<T> feature, T input, Optional<SharedObjects> sharedObjects, double expectedResult) throws FeatureCalculationException {
        FeatureTestCalculator.assertResultTolerance(message, feature, input, FeatureTestCalculator.createInitialization(sharedObjects), expectedResult, 1.0E-4);
    }

    public static <T extends FeatureInput> void assertIntResult(String message, Feature<T> feature, T input, Optional<SharedObjects> sharedObjects, int expectedResult) throws FeatureCalculationException {
        FeatureTestCalculator.assertResultTolerance(message, feature, input, FeatureTestCalculator.createInitialization(sharedObjects), expectedResult, 1.0E-20);
    }

    private static FeatureInitialization createInitialization(Optional<SharedObjects> sharedObjects) {
        Optional<FeatureInitialization> mapped = sharedObjects.map(FeatureInitialization::new);
        return mapped.orElse(new FeatureInitialization());
    }

    private static <T extends FeatureInput> void assertResultTolerance(String message, Feature<T> feature, T input, FeatureInitialization initialization, double expectedResult, double delta) throws FeatureCalculationException {
        double result = FeatureTestCalculator.calculateSequentialSession(feature, input, initialization);
        Assertions.assertEquals((double)expectedResult, (double)result, (double)delta, (String)message);
    }

    private static <T extends FeatureInput> double calculateSequentialSession(Feature<T> feature, T input, FeatureInitialization initialization) throws FeatureCalculationException {
        try {
            FeatureCalculatorSingle calculator = FeatureSession.with(feature, (FeatureInitialization)initialization, (SharedFeatures)new SharedFeatures(), (Logger)LoggerFixture.suppressedLogger());
            return calculator.calculate(input);
        }
        catch (InitializeException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private FeatureTestCalculator() {
    }
}

