/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.feature.plugins.objects;

import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.regionmap.RegionMapSingleton;
import org.anchoranalysis.mpp.mark.conic.Circle;
import org.anchoranalysis.spatial.point.Point2i;
import org.anchoranalysis.spatial.point.PointConverter;

public class CircleObjectFixture {
    private static final Dimensions DIMS = new Dimensions(800, 600, 1);

    public static ObjectMask circleAt(Point2i center, double radius) {
        Circle mark = new Circle();
        mark.setPosition(PointConverter.doubleFromInt((Point2i)center));
        mark.setRadius(radius);
        return mark.deriveObject(DIMS, RegionMapSingleton.instance().membershipWithFlagsForIndex(0), BinaryValuesByte.getDefault());
    }

    public static EnergyStack energyStack() {
        return new EnergyStack(DIMS);
    }

    public static boolean sceneContains(Point2i point) {
        return DIMS.contains(PointConverter.convertTo3i((Point2i)point));
    }

    private CircleObjectFixture() {
    }
}

