/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.feature.plugins.objects;

import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.Point2i;
import org.anchoranalysis.test.feature.plugins.objects.CircleObjectFixture;

public class IntersectingCircleObjectsFixture {
    private static final int INITIAL_MARGIN = 5;
    private static final int INITIAL_RADIUS = 5;
    private static final int RADIUS_INCR = 2;

    public static ObjectCollection generateIntersectingObjects(int numberIntersecting, int numberNotIntersecting, boolean sameSize) {
        RunningCircleCreator running = new RunningCircleCreator(sameSize);
        ObjectCollection first = running.generateMultipleCircles(numberIntersecting, 1.5);
        running.shift(1.5);
        ObjectCollection second = running.generateMultipleCircles(numberNotIntersecting, 3.0);
        assert (CircleObjectFixture.sceneContains(running.getCenter()));
        return ObjectCollectionFactory.of((ObjectCollection[])new ObjectCollection[]{first, second});
    }

    private IntersectingCircleObjectsFixture() {
    }

    private static class RunningCircleCreator {
        private boolean sameSize;
        private int radius = 5;
        private Point2i center = new Point2i(5 + this.radius, 5 + this.radius);

        public RunningCircleCreator(boolean sameSize) {
            this.sameSize = sameSize;
        }

        public void shift(double factor) {
            int shift = (int)(factor * (double)this.radius);
            this.center.incrementX(shift);
            this.center.incrementY(shift);
        }

        public ObjectCollection generateMultipleCircles(int numCircles, double factor) {
            return ObjectCollectionFactory.fromRepeated((int)numCircles, () -> this.generateCircle(factor));
        }

        private ObjectMask generateCircle(double factor) {
            ObjectMask object = CircleObjectFixture.circleAt(this.center, this.radius);
            this.shift(factor);
            if (!this.sameSize) {
                this.radius += 2;
            }
            return object;
        }

        public Point2i getCenter() {
            return this.center;
        }
    }
}

