/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.feature.plugins;

import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.xml.BeanXMLLoader;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.test.TestLoader;
import org.junit.jupiter.api.Assertions;

public class FeaturesFromXMLFixture {
    public static <T extends FeatureInput> FeatureList<T> createFeatureList(String xmlPath, TestLoader loader) throws CreateException {
        Path pathStatic = loader.resolveTestPath(xmlPath);
        try {
            FeatureListProvider provider = (FeatureListProvider)BeanXMLLoader.loadBean((Path)pathStatic);
            FeatureList features = (FeatureList)provider.get();
            Assertions.assertTrue((!features.isEmpty() ? 1 : 0) != 0);
            return features;
        }
        catch (BeanXMLException | ProvisionFailedException e) {
            throw new CreateException(e);
        }
    }

    public static <T extends FeatureInput> List<NamedBean<FeatureListProvider<T>>> createNamedFeatureProviders(String xmlPath, TestLoader loader) throws CreateException {
        Path pathStatic = loader.resolveTestPath(xmlPath);
        try {
            List list = (List)BeanXMLLoader.loadBean((Path)pathStatic);
            Assertions.assertTrue((!list.isEmpty() ? 1 : 0) != 0);
            return list;
        }
        catch (BeanXMLException e) {
            throw new CreateException((Throwable)e);
        }
    }

    @Generated
    private FeaturesFromXMLFixture() {
    }
}

