/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.feature.plugins.mockfeature;

import java.util.function.ToDoubleFunction;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedRunnable;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.test.feature.plugins.mockfeature.MockCalculation;
import org.anchoranalysis.test.feature.plugins.mockfeature.MockFeatureWithCalculation;
import org.junit.jupiter.api.Assertions;

public class MockFeatureWithCalculationFixture {
    public static final ToDoubleFunction<FeatureInputSingleObject> DEFAULT_FUNC_NUM_PIXELS = input -> input.getObject().numberVoxelsOn();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeAndAssertCount(int expectedCountCalc, int expectedCountExecute, CheckedRunnable<OperationFailedException> operation) throws OperationFailedException {
        Class<MockCalculation> clazz = MockCalculation.class;
        synchronized (MockCalculation.class) {
            long beforeExecute = MockCalculation.countExecuteCalled;
            long beforeCalc = MockFeatureWithCalculation.countCalculateCalled;
            operation.run();
            Assertions.assertEquals((long)expectedCountExecute, (long)((long)MockCalculation.countExecuteCalled - beforeExecute), (String)"count of times execute() called on MockCalculation");
            Assertions.assertEquals((long)expectedCountCalc, (long)((long)MockFeatureWithCalculation.countCalculateCalled - beforeCalc), (String)"count of times calculate() called on MockFeature");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static Feature<FeatureInputSingleObject> createMockFeatureWithCalculation() {
        return MockFeatureWithCalculationFixture.createMockFeatureWithCalculation(DEFAULT_FUNC_NUM_PIXELS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends FeatureInput> Feature<T> createMockFeatureWithCalculation(ToDoubleFunction<T> funcCalculation) {
        Class<MockCalculation> clazz = MockCalculation.class;
        synchronized (MockCalculation.class) {
            MockCalculation.funcCalculation = funcCalculation;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new MockFeatureWithCalculation();
        }
    }

    @Generated
    private MockFeatureWithCalculationFixture() {
    }
}

