/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.feature;

import lombok.Generated;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.bean.operator.Constant;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.junit.jupiter.api.Assertions;

public class ConstantsInListFixture {
    private static final double F1_VALUE = 1.0;
    private static final double F2_VALUE = 2.0;
    private static final double F3_VALUE = 3.0;
    private static final double EPS = 1.0E-16;

    public static <T extends FeatureInput> FeatureList<T> create() {
        return FeatureListFactory.from((Feature[])new Feature[]{ConstantsInListFixture.constantFeatureFor(1.0), ConstantsInListFixture.constantFeatureFor(2.0), ConstantsInListFixture.constantFeatureFor(3.0)});
    }

    public static void checkResultsVector(ResultsVector vector) {
        Assertions.assertTrue((boolean)vector.equalsPrecision(1.0E-16, new Object[]{1.0, 2.0, 3.0}));
    }

    private static <T extends FeatureInput> Feature<T> constantFeatureFor(double value) {
        return new Constant(value);
    }

    @Generated
    private ConstantsInListFixture() {
    }
}

