/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;

class DirectoriesComparer {
    public static boolean areDirectoriesEqual(Path directory1, Path directory2) {
        return DirectoriesComparer.areDirectoriesEqual(directory1.toFile(), directory2.toFile());
    }

    private static File[] sortedFilesForDirectory(File directories) {
        Object[] files = directories.listFiles();
        Arrays.sort(files);
        return files;
    }

    private static boolean areDirectoriesEqual(File dir1, File dir2) {
        Preconditions.checkArgument((boolean)dir1.isDirectory());
        Preconditions.checkArgument((boolean)dir2.isDirectory());
        File[] list1 = DirectoriesComparer.sortedFilesForDirectory(dir1);
        File[] list2 = DirectoriesComparer.sortedFilesForDirectory(dir2);
        if (list1.length != list2.length) {
            return false;
        }
        for (int i = 0; i < list2.length; ++i) {
            if (list1[i].isFile() && list2[i].isFile()) {
                if (DirectoriesComparer.compareFiles(list1[i], list2[i])) continue;
                return false;
            }
            if (list1[i].isDirectory() && list2[i].isDirectory()) {
                if (DirectoriesComparer.areDirectoriesEqual(list1[i], list2[i])) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compareFiles(File file1, File file2) {
        long index2;
        long index1 = file1.length();
        if (index1 != (index2 = file2.length())) {
            return false;
        }
        try (DataInputStream stream1 = DirectoriesComparer.streamFor(file1);
             DataInputStream stream2 = DirectoriesComparer.streamFor(file2);){
            byte byte2;
            byte byte1;
            while ((byte1 = stream1.readByte()) == (byte2 = stream2.readByte())) {
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private static DataInputStream streamFor(File file) throws FileNotFoundException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    private DirectoriesComparer() {
    }
}

