/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.test.CompareXML;
import org.anchoranalysis.test.TestLoader;
import org.anchoranalysis.test.image.DirectoriesComparer;
import org.anchoranalysis.test.image.csv.CSVComparer;
import org.anchoranalysis.test.image.io.TestLoaderImage;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;

public class DualComparer {
    private final TestLoader loader1;
    private final TestLoader loader2;
    private final TestLoaderImage loaderImage1;
    private final TestLoaderImage loaderImage2;

    public DualComparer(TestLoader loader1, TestLoader loader2) {
        this.loader1 = loader1;
        this.loader2 = loader2;
        this.loaderImage1 = new TestLoaderImage(loader1);
        this.loaderImage2 = new TestLoaderImage(loader2);
    }

    public boolean compareTwoImages(String path) throws FileNotFoundException {
        return TestLoaderImage.compareTwoImages(this.loaderImage1, path, this.loaderImage2, path, false);
    }

    public boolean compareTwoImages(String path1, String path2, boolean ignoreResolutionDifferences) throws FileNotFoundException {
        return TestLoaderImage.compareTwoImages(this.loaderImage1, path1, this.loaderImage2, path2, ignoreResolutionDifferences);
    }

    public boolean compareTwoXmlDocuments(String path) {
        return CompareXML.areDocumentsEqual((Document)this.loader1.openXmlFromTestPath(path), (Document)this.loader2.openXmlFromTestPath(path));
    }

    public boolean compareTwoCsvFiles(String path, CSVComparer comparer, PrintStream messageStream) throws CSVReaderException {
        return comparer.areCSVFilesEqual(this.loaderImage1.resolveTestPath(path), this.loaderImage2.resolveTestPath(path), messageStream);
    }

    public boolean compareTwoObjectCollections(String path) throws IOException {
        ObjectCollection objects1 = this.loaderImage1.openObjectsFromTestPath(path);
        ObjectCollection objects2 = this.loaderImage2.openObjectsFromTestPath(path);
        return objects1.equalsDeep(objects2);
    }

    public boolean compareTwoBinaryFiles(String path) throws IOException {
        return Files.equal((File)this.loaderImage1.resolveTestPath(path).toFile(), (File)this.loaderImage2.resolveTestPath(path).toFile());
    }

    public boolean compareTwoSubdirectories(String path) {
        Path dir1 = this.loaderImage1.resolveTestPath(path);
        Path dir2 = this.loaderImage2.resolveTestPath(path);
        return DirectoriesComparer.areDirectoriesEqual(dir1, dir2);
    }

    public void copyFromPath1ToPath2(String path) throws IOException {
        FileUtils.copyFile((File)this.loaderImage1.resolveTestPath(path).toFile(), (File)this.loaderImage2.resolveTestPath(path).toFile());
    }

    public TestLoader getLoader1() {
        return this.loader1;
    }

    public TestLoader getLoader2() {
        return this.loader2;
    }
}

