/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.test.image.ChannelFixture;

public class EnergyStackFixture {
    public static EnergyStack create(boolean big, boolean do3D) {
        return EnergyStackFixture.create(big, do3D, false, true);
    }

    public static EnergyStack create(boolean big, boolean do3D, boolean singleChannel, boolean includeResolution) {
        ChannelFixture fixture = new ChannelFixture(includeResolution);
        Extent size = EnergyStackFixture.multiplexExtent(big, do3D);
        try {
            Stack stack = new Stack();
            EnergyStackFixture.addChannel(stack, size, ChannelFixture::sumModulo, fixture);
            if (!singleChannel) {
                EnergyStackFixture.addChannel(stack, size, ChannelFixture::diffModulo, fixture);
                EnergyStackFixture.addChannel(stack, size, ChannelFixture::multModulo, fixture);
            }
            return new EnergyStack(stack);
        }
        catch (IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    private static Extent multiplexExtent(boolean big, boolean do3D) {
        if (do3D) {
            return big ? ChannelFixture.LARGE_3D : ChannelFixture.MEDIUM_3D;
        }
        return big ? ChannelFixture.LARGE_2D : ChannelFixture.MEDIUM_2D;
    }

    private static void addChannel(Stack stack, Extent size, ChannelFixture.IntensityFunction intensityFunction, ChannelFixture fixture) throws IncorrectImageSizeException {
        stack.addChannel(fixture.createChannel(size, intensityFunction, (VoxelDataType)UnsignedByteVoxelType.INSTANCE));
    }

    private EnergyStackFixture() {
    }
}

