/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import java.nio.file.Path;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.test.LoggerFixture;
import org.mockito.Mockito;

public class InputOutputContextFixture {
    public static InputOutputContext withSuppressedLogger(Path modelDir) {
        InputOutputContext out = InputOutputContextFixture.withSuppressedLogger();
        Mockito.when((Object)out.getModelDirectory()).thenReturn((Object)modelDir);
        return out;
    }

    public static InputOutputContext withSuppressedLogger() {
        return InputOutputContextFixture.withLogger(LoggerFixture.suppressedLogger());
    }

    public static InputOutputContext withLogger(Logger logger) {
        InputOutputContext out = (InputOutputContext)Mockito.spy(InputOutputContext.class);
        Mockito.when((Object)out.getLogger()).thenReturn((Object)logger);
        Mockito.when((Object)out.getMessageReporter()).thenReturn((Object)logger.messageLogger());
        Mockito.when((Object)out.getErrorReporter()).thenReturn((Object)logger.errorReporter());
        return out;
    }

    private InputOutputContextFixture() {
    }
}

