/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import java.util.Optional;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.test.image.ChannelFixture;

public class MaskFixture {
    private static final Point3i DEFAULT_CORNER = new Point3i(14, 2, 2);
    private static final Point3i BOX_EXTENT = new Point3i(40, 7, 3);

    public static Mask create(boolean do3D) {
        return MaskFixture.create(DEFAULT_CORNER, do3D);
    }

    public static Mask create(boolean do3D, Optional<Resolution> resolution) {
        return MaskFixture.create(DEFAULT_CORNER, do3D, resolution);
    }

    public static Mask create(Point3i corner, boolean do3D) {
        return MaskFixture.create(corner, do3D, Optional.empty());
    }

    public static Mask create(Point3i corner, boolean do3D, Optional<Resolution> resolution) {
        Mask mask = new Mask(BinaryVoxelsFactory.createEmptyOff((Extent)MaskFixture.maskExtent(do3D)), resolution);
        mask.assignOn().toBox(MaskFixture.createRectange(corner, do3D));
        return mask;
    }

    public static Extent maskExtent(boolean do3D) {
        return do3D ? ChannelFixture.MEDIUM_3D : ChannelFixture.MEDIUM_2D;
    }

    public static int width() {
        return BOX_EXTENT.x();
    }

    public static int height() {
        return BOX_EXTENT.y();
    }

    public static int depth(boolean do3D) {
        return do3D ? BOX_EXTENT.z() : 1;
    }

    private static BoundingBox createRectange(Point3i corner, boolean do3D) {
        Extent extentCorrected = Extent.createFromTupleReuse((ReadableTuple3i)MaskFixture.maybeSuppressZ(BOX_EXTENT, do3D, 1));
        Point3i cornerCorrected = MaskFixture.maybeSuppressZ(corner, do3D, 0);
        return BoundingBox.createReuse((ReadableTuple3i)cornerCorrected, (Extent)extentCorrected);
    }

    private static Point3i maybeSuppressZ(Point3i point, boolean do3D, int suppressedValue) {
        if (do3D) {
            return new Point3i((ReadableTuple3i)point);
        }
        return new Point3i(point.x(), point.y(), suppressedValue);
    }

    private MaskFixture() {
    }
}

