/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.test.image.ChannelFixture;
import org.anchoranalysis.test.image.stackwriter.ChannelSpecification;

public class StackFixture {
    private ChannelFixture channelFixture = new ChannelFixture();
    private Optional<VoxelDataType> firstChannelVoxelType = Optional.empty();

    public StackFixture(Optional<VoxelDataType> firstChannelVoxelType) {
        this.firstChannelVoxelType = firstChannelVoxelType;
    }

    public Stack create(ChannelSpecification channelSpecification, Extent extent) {
        Stream<Channel> channels = IntStream.range(0, channelSpecification.getNumberChannels()).mapToObj(index -> this.createChannel(index, extent, channelSpecification.getChannelVoxelType()));
        try {
            return new Stack(channelSpecification.isMakeRGB(), channels);
        }
        catch (IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    private Channel createChannel(int index, Extent extent, VoxelDataType defaultChannelVoxelType) {
        VoxelDataType voxelType = index == 0 && this.firstChannelVoxelType.isPresent() ? this.firstChannelVoxelType.get() : defaultChannelVoxelType;
        return this.channelFixture.createChannel(extent, StackFixture.multiplexIntensity(index), voxelType);
    }

    private static ChannelFixture.IntensityFunction multiplexIntensity(int channelIndex) {
        switch (channelIndex) {
            case 0: {
                return ChannelFixture::sumModulo;
            }
            case 1: {
                return ChannelFixture::diffModulo;
            }
            case 2: {
                return ChannelFixture::multModulo;
            }
        }
        return ChannelFixture::sumModulo;
    }

    public StackFixture() {
    }
}

