/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.csv;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.TreeSet;
import org.anchoranalysis.io.input.csv.CSVReader;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.test.image.csv.CompareUtilities;

class CompareSorted {
    private TreeSet<String[]> sortedLines1;
    private TreeSet<String[]> sortedLines2;
    private int ignoreFirstNumColumns;
    private boolean rejectZeroRows;

    public CompareSorted(int ignoreFirstNumColumns, boolean rejectZeroRows) {
        this.ignoreFirstNumColumns = ignoreFirstNumColumns;
        this.rejectZeroRows = rejectZeroRows;
        StringArrayComparator comparator = new StringArrayComparator();
        this.sortedLines1 = new TreeSet<String[]>(comparator);
        this.sortedLines2 = new TreeSet<String[]>(comparator);
    }

    public boolean compare(CSVReader.OpenedCSVFile file1, CSVReader.OpenedCSVFile file2, PrintStream messageStream) throws CSVReaderException {
        this.sortedLines1.clear();
        this.sortedLines2.clear();
        if (!this.loadFromFiles(file1, file2)) {
            messageStream.println("files have a different number of lines");
            return false;
        }
        return this.compareSets(messageStream);
    }

    private boolean loadFromFiles(CSVReader.OpenedCSVFile file1, CSVReader.OpenedCSVFile file2) throws CSVReaderException {
        try {
            boolean first = true;
            while (true) {
                Optional lines1 = file1.readLine();
                Optional lines2 = file2.readLine();
                if (first) {
                    CompareUtilities.checkZeroRows(this.rejectZeroRows, lines1, lines2);
                    first = false;
                }
                if (!lines1.isPresent() || !lines2.isPresent()) {
                    return !lines1.isPresent() && !lines2.isPresent();
                }
                this.sortedLines1.add((String[])lines1.get());
                this.sortedLines2.add((String[])lines2.get());
            }
        }
        catch (IOException e) {
            throw new CSVReaderException((Throwable)e);
        }
    }

    private boolean compareSets(PrintStream messageStream) {
        Iterator<String[]> itr1 = this.sortedLines1.iterator();
        Iterator<String[]> itr2 = this.sortedLines2.iterator();
        while (itr1.hasNext()) {
            assert (itr2.hasNext());
            String[] line1 = itr1.next();
            String[] line2 = itr2.next();
            if (CompareUtilities.areArraysEqual(Optional.of(line1), Optional.of(line2), this.ignoreFirstNumColumns)) continue;
            messageStream.println("The following lines are not identical:");
            CompareUtilities.printTwoLines(messageStream, line1, line2, "  ");
            return false;
        }
        return true;
    }

    private static class StringArrayComparator
    implements Comparator<String[]> {
        private StringArrayComparator() {
        }

        @Override
        public int compare(String[] arg0, String[] arg1) {
            int compare = Integer.compare(arg0.length, arg1.length);
            if (compare != 0) {
                return compare;
            }
            for (int i = 0; i < arg0.length; ++i) {
                String str0 = arg0[i];
                String str1 = arg1[i];
                compare = str0.compareTo(str1);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }
}

