/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.io;

import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.xml.RegisterBeanFactories;
import org.anchoranalysis.bean.xml.factory.AnchorDefaultBeanFactory;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.image.bean.displayer.IntensityQuantiles;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.bean.interpolator.ImgLib2Linear;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.FromStackReader;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.io.bioformats.ConfigureBioformatsLogging;
import org.anchoranalysis.io.bioformats.bean.BioformatsReader;
import org.anchoranalysis.io.bioformats.bean.options.ForceTimeSeriesToStack;
import org.anchoranalysis.io.bioformats.bean.options.ReadOptions;
import org.anchoranalysis.io.bioformats.bean.writer.Tiff;
import org.anchoranalysis.io.imagej.bean.stack.writer.PNG;
import org.apache.commons.configuration.beanutils.BeanHelper;

public class BeanInstanceMapFixture {
    public static StackReader ensureStackReader() {
        return (StackReader)BeanInstanceMapFixture.addOrReplace(StackReader.class, new BioformatsReader((ReadOptions)new ForceTimeSeriesToStack()));
    }

    public static StackWriter ensureStackWriter(boolean tiff) {
        return (StackWriter)BeanInstanceMapFixture.addOrReplace(StackWriter.class, tiff ? new Tiff() : new PNG());
    }

    public static void removeStackWriter() {
        BeanInstanceMapFixture.getOrCreateBeanFactory().getDefaultInstances().removeInstanceFor(StackWriter.class);
    }

    public static ImageMetadataReader ensureImageMetadataReader() {
        return (ImageMetadataReader)BeanInstanceMapFixture.addOrReplace(ImageMetadataReader.class, new FromStackReader(BeanInstanceMapFixture.ensureStackReader()));
    }

    public static Interpolator ensureInterpolator() {
        return BeanInstanceMapFixture.ensureInterpolator((Interpolator)new ImgLib2Linear());
    }

    public static Interpolator ensureInterpolator(Interpolator interpolator) {
        return BeanInstanceMapFixture.addOrReplace(Interpolator.class, interpolator);
    }

    public static StackDisplayer ensureStackDisplayer() {
        return (StackDisplayer)BeanInstanceMapFixture.addOrReplace(StackDisplayer.class, new IntensityQuantiles());
    }

    public static <T extends AnchorBean<?>> T check(T bean) {
        try {
            bean.checkMisconfigured(BeanInstanceMapFixture.getOrCreateBeanFactory().getDefaultInstances());
        }
        catch (BeanMisconfiguredException e) {
            throw new AnchorFriendlyRuntimeException((Throwable)e);
        }
        return bean;
    }

    private static AnchorDefaultBeanFactory getOrCreateBeanFactory() {
        if (!RegisterBeanFactories.isCalledRegisterAllPackage()) {
            return RegisterBeanFactories.registerAllPackageBeanFactories();
        }
        return (AnchorDefaultBeanFactory)BeanHelper.getDefaultBeanFactory();
    }

    private static <T> T addOrReplace(Class<T> cls, T instance) {
        BeanInstanceMapFixture.getOrCreateBeanFactory().getDefaultInstances().putInstanceFor(cls, instance);
        return instance;
    }

    private BeanInstanceMapFixture() {
    }

    static {
        ConfigureBioformatsLogging.instance().makeSureConfigured();
    }
}

