/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.object;

import java.util.ArrayList;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsBoundingBox;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class CircleObjectFixture {
    public static ObjectCollection successiveCircles(int numberCircles, Point2d startCenter, int radius, Point2d centerShift, double radiusShift) {
        ArrayList<ObjectMask> objects = new ArrayList<ObjectMask>(numberCircles);
        Point2d currentCenter = startCenter;
        double currentRadius = radius;
        for (int i = 0; i < numberCircles; ++i) {
            objects.add(CircleObjectFixture.circleAt(currentCenter, (int)currentRadius));
            currentCenter.add(centerShift);
            currentRadius += radiusShift;
        }
        return new ObjectCollection(objects);
    }

    public static ObjectMask circleAt(Point2d center, int radius) {
        Point3d center3d = PointConverter.convertTo3d((Point2d)center);
        BoundingBox box = CircleObjectFixture.boundingBoxForCircle(center3d, radius);
        double radiusSquared = Math.pow(radius, 2.0);
        ObjectMask object = new ObjectMask(box);
        VoxelsAssigner assigner = object.assignOn();
        IterateVoxelsBoundingBox.withMatchingPoints((BoundingBox)box, point -> center3d.distanceSquared(point) <= radiusSquared, arg_0 -> ((VoxelsAssigner)assigner).toVoxel(arg_0));
        return object;
    }

    private static BoundingBox boundingBoxForCircle(Point3d center3d, int radius) {
        Point3i centerCeil = PointConverter.intFromDoubleCeil((Point3d)center3d);
        Point3i centerFloor = PointConverter.intFromDoubleFloor((Point3d)center3d);
        Point3i radii = new Point3i(radius, radius, 0);
        centerFloor.subtract((ReadableTuple3i)radii);
        centerCeil.add((ReadableTuple3i)radii);
        return BoundingBox.createReuse((ReadableTuple3i)centerFloor, (ReadableTuple3i)centerCeil);
    }

    private CircleObjectFixture() {
    }
}

