/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.object;

import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.binary.connected.ObjectsFromConnectedComponentsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.test.TestLoader;
import org.anchoranalysis.test.image.io.TestLoaderImage;

public class TestLoaderObjects {
    private static final ObjectsFromConnectedComponentsFactory FACTORY = new ObjectsFromConnectedComponentsFactory();
    private final TestLoaderImage loader;

    public TestLoaderObjects(TestLoader loader) {
        this.loader = new TestLoaderImage(loader);
    }

    public ObjectMask openLargestObjectFrom(String suffix) {
        Stack stack = this.loader.openStackFromTestPath(TestLoaderObjects.path(suffix));
        return TestLoaderObjects.largestObjectFromStack(stack);
    }

    private static ObjectMask largestObjectFromStack(Stack stack) {
        Mask mask = new Mask(stack.getChannel(0));
        return TestLoaderObjects.findLargestObject(FACTORY.createUnsignedByte(mask.binaryVoxels()));
    }

    private static ObjectMask findLargestObject(ObjectCollection objects) {
        return (ObjectMask)objects.streamStandardJava().max(TestLoaderObjects::compareObjectsByNumberVoxelsOn).get();
    }

    private static int compareObjectsByNumberVoxelsOn(ObjectMask object1, ObjectMask object2) {
        return Integer.compare(object1.numberVoxelsOn(), object2.numberVoxelsOn());
    }

    private static String path(String suffix) {
        return String.format("binaryImageObj/obj%s.tif", suffix);
    }

    public TestLoaderObjects(TestLoaderImage loader) {
        this.loader = loader;
    }
}

