/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.rasterwriter.comparison;

import java.io.IOException;
import java.nio.file.Path;
import org.anchoranalysis.test.image.DualComparer;
import org.anchoranalysis.test.image.rasterwriter.comparison.ImageComparer;
import org.junit.jupiter.api.Assertions;

abstract class CompareBase
implements ImageComparer {
    protected DualComparer comparer;

    @Override
    public void assertIdentical(String filenameWithoutExtension, String filenameWithExtension, Path path) throws IOException {
        try {
            String assertMessage = filenameWithoutExtension + "_" + this.identifierForTest();
            Assertions.assertTrue((boolean)this.areIdentical(filenameWithoutExtension, filenameWithExtension), (String)assertMessage);
        }
        catch (IOException e) {
            System.err.printf("The test wrote a file to temporary-folder directory at:%n%s%n", path);
            throw new IOException(String.format("The comparer threw an IOException, which likely means it cannot find an appropriate raster to compare against for %s.", filenameWithoutExtension), e);
        }
    }

    protected abstract boolean areIdentical(String var1, String var2) throws IOException;

    protected abstract String identifierForTest();

    public CompareBase(DualComparer comparer) {
        this.comparer = comparer;
    }
}

