/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.rasterwriter.comparison;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.anchoranalysis.test.image.rasterwriter.comparison.ImageComparer;

class CopyMissingImages
implements ImageComparer {
    private ImageComparer comparer;
    private Path directoryToCopyTo;

    @Override
    public void assertIdentical(String filenameWithoutExtension, String filenameWithExtension, Path path) throws IOException {
        try {
            this.comparer.assertIdentical(filenameWithoutExtension, filenameWithExtension, path);
        }
        catch (IOException e) {
            if (this.directoryToCopyTo.toFile().isDirectory()) {
                Files.copy(path, this.directoryToCopyTo.resolve(filenameWithExtension), new CopyOption[0]);
            }
            throw new IOException("directoryToCopyTo does not specify a path to a directory: " + this.directoryToCopyTo);
        }
    }

    public CopyMissingImages(ImageComparer comparer, Path directoryToCopyTo) {
        this.comparer = comparer;
        this.directoryToCopyTo = directoryToCopyTo;
    }
}

