/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.segment;

import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.IntersectionOverUnion;
import org.junit.jupiter.api.Assertions;

class ExpectedBoxesChecker {
    private static final double THRESHOLD_SCORE = 0.4;

    public static void assertExpectedBoxes(ObjectCollection objects, BoundingBox targetBox) {
        Assertions.assertTrue((boolean)ExpectedBoxesChecker.atLeastOneObjectOverlaps(objects, targetBox), (String)("at least one object has box: " + targetBox.toString()));
    }

    private static boolean atLeastOneObjectOverlaps(ObjectCollection objects, BoundingBox box) {
        return objects.stream().anyMatch(object -> IntersectionOverUnion.forBoxes((BoundingBox)object.boundingBox(), (BoundingBox)box) > 0.4);
    }

    private ExpectedBoxesChecker() {
    }
}

