/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.segment;

import java.nio.file.Path;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.time.ExecutionTimeRecorderIgnore;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.bean.segment.instance.SegmentStackIntoObjectsPooled;
import org.anchoranalysis.image.inference.segment.SegmentedObjects;
import org.anchoranalysis.image.inference.segment.SegmentedObjectsAtScale;
import org.anchoranalysis.image.io.ImageInitializationFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.test.TestLoader;
import org.anchoranalysis.test.image.InputOutputContextFixture;
import org.anchoranalysis.test.image.WriteIntoDirectory;
import org.anchoranalysis.test.image.load.CarImageLoader;
import org.anchoranalysis.test.image.segment.ExpectedBoxesChecker;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class InstanceSegmentationTestBase {
    private SegmentStackIntoObjectsPooled<?> segmenter;
    @TempDir
    Path temporaryDirectory;
    private WriteIntoDirectory writer;
    private CarImageLoader loader = new CarImageLoader();

    @BeforeEach
    public void setup() throws InitializeException {
        this.writer = new WriteIntoDirectory(this.temporaryDirectory, false);
        this.segmenter = this.createSegmenter();
        InstanceSegmentationTestBase.initSegmenter(this.segmenter);
    }

    @Test
    public void testRGB() throws SegmentationFailedException {
        this.assertExpectedSegmentation(this.stackRGB(), this.targetBox(), "rgb");
    }

    @Test
    public void testGrayscale8Bit() throws SegmentationFailedException {
        this.assertExpectedSegmentation(this.stackGrayscale(), this.targetBox(), "grayscale");
    }

    protected abstract SegmentStackIntoObjectsPooled<?> createSegmenter();

    protected Stack stackRGB() {
        return this.loader.carRGB();
    }

    protected Stack stackGrayscale() {
        return this.loader.carGrayscale8Bit();
    }

    protected abstract BoundingBox targetBox();

    private void assertExpectedSegmentation(Stack stack, BoundingBox targetBox, String suffix) throws SegmentationFailedException {
        SegmentedObjects segmentResults = this.segmenter.segment(stack, ExecutionTimeRecorderIgnore.instance());
        ObjectCollection objects = ((SegmentedObjectsAtScale)segmentResults.getObjects().atInputScale()).objects();
        this.writer.writeObjects("objects_" + suffix, objects, this.stackRGB());
        ExpectedBoxesChecker.assertExpectedBoxes(objects, targetBox);
    }

    private static void initSegmenter(SegmentStackIntoObjectsPooled<?> segmenter) throws InitializeException {
        Path root = TestLoader.createFromMavenWorkingDirectory().getRoot();
        InputOutputContext context = InputOutputContextFixture.withSuppressedLogger(root);
        segmenter.initializeRecursive((BeanInitialization)ImageInitializationFactory.create((InputOutputContext)context), context.getLogger());
    }
}

