/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.stackwriter;

import java.io.IOException;
import java.util.Optional;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.test.image.rasterwriter.comparison.ImageComparer;
import org.anchoranalysis.test.image.stackwriter.ChannelSpecification;
import org.anchoranalysis.test.image.stackwriter.StackTester;

public class FourChannelStackTester {
    private static final VoxelDataType[] DEFAULT_VOXEL_TYPE_AS_ARRAY = new VoxelDataType[]{UnsignedByteVoxelType.INSTANCE};
    private final StackTester tester;
    private final Optional<ImageComparer> comparer;
    private final Optional<ImageComparer> comparerRGB;

    public FourChannelStackTester(StackTester tester, ImageComparer comparer, boolean skipComparisonForRGB) {
        this.tester = tester;
        this.comparer = Optional.of(comparer);
        this.comparerRGB = OptionalFactory.create((!skipComparisonForRGB ? 1 : 0) != 0, () -> comparer);
    }

    public void testSingleChannel() throws ImageIOException, IOException {
        this.testSingleChannel(DEFAULT_VOXEL_TYPE_AS_ARRAY);
    }

    public void testSingleChannel(VoxelDataType channelVoxelType) throws ImageIOException, IOException {
        this.testSingleChannel(new VoxelDataType[]{channelVoxelType});
    }

    public void testSingleChannel(VoxelDataType[] channelVoxelTypes) throws ImageIOException, IOException {
        this.tester.performTest(channelVoxelTypes, 1, false, this.comparer);
    }

    public void testSingleChannelRGB() throws ImageIOException, IOException {
        this.tester.performTest(new ChannelSpecification((VoxelDataType)UnsignedByteVoxelType.INSTANCE, 1, true), this.comparerRGB);
    }

    public void testTwoChannels() throws ImageIOException, IOException {
        this.testTwoChannels(DEFAULT_VOXEL_TYPE_AS_ARRAY);
    }

    public void testTwoChannels(VoxelDataType[] channelVoxelTypes) throws ImageIOException, IOException {
        this.tester.performTest(channelVoxelTypes, 2, false, this.comparer);
    }

    public void testThreeChannelsSeparate() throws ImageIOException, IOException {
        this.testThreeChannelsSeparate(DEFAULT_VOXEL_TYPE_AS_ARRAY);
    }

    public void testThreeChannelsSeparate(VoxelDataType[] channelVoxelTypes) throws ImageIOException, IOException {
        this.tester.performTest(channelVoxelTypes, 3, false, this.comparer);
    }

    public void testThreeChannelsRGB() throws ImageIOException, IOException {
        this.testThreeChannelsRGB(DEFAULT_VOXEL_TYPE_AS_ARRAY);
    }

    public void testThreeChannelsRGB(VoxelDataType channelVoxelType) throws ImageIOException, IOException {
        this.testThreeChannelsRGB(new VoxelDataType[]{channelVoxelType});
    }

    public void testThreeChannelsRGB(VoxelDataType[] channelVoxelTypes) throws ImageIOException, IOException {
        this.tester.performTest(channelVoxelTypes, 3, true, this.comparerRGB);
    }

    public void testThreeChannelsHeterogeneous() throws ImageIOException, IOException {
        this.tester.performTest(new ChannelSpecification((VoxelDataType)UnsignedByteVoxelType.INSTANCE, 3, false), Optional.of(UnsignedShortVoxelType.INSTANCE), this.comparer);
    }

    public void testFourChannels() throws ImageIOException, IOException {
        this.testFourChannels(DEFAULT_VOXEL_TYPE_AS_ARRAY);
    }

    public void testFourChannels(VoxelDataType[] channelVoxelTypes) throws ImageIOException, IOException {
        this.tester.performTest(channelVoxelTypes, 4, false, this.comparer);
    }
}

