/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.stackwriter;

import org.anchoranalysis.test.image.stackwriter.ChannelSpecification;

public class IdentifierHelper {
    public static String identiferFor(ChannelSpecification channels, boolean do3D, String extentIdentifier, boolean firstChannelForced) {
        StringBuilder builder = new StringBuilder();
        builder.append(channels.getChannelVoxelType().toString());
        builder.append("_");
        builder.append(IdentifierHelper.identifierForNumberChannels(channels.getNumberChannels(), channels.isMakeRGB()));
        builder.append("_");
        builder.append(IdentifierHelper.identifierForDimensions(do3D));
        builder.append("_");
        builder.append(extentIdentifier);
        if (firstChannelForced) {
            builder.append("_firstChannelDifferentType");
        }
        return builder.toString();
    }

    private static String identifierForDimensions(boolean do3D) {
        if (do3D) {
            return "3D";
        }
        return "2D";
    }

    private static String identifierForNumberChannels(int numberChannels, boolean makeRGB) {
        switch (numberChannels) {
            case 1: {
                return "singleChannel";
            }
            case 2: {
                return "twoChannels";
            }
            case 3: {
                return makeRGB ? "threeChannelsRGB" : "threeChannelsSeparate";
            }
            case 4: {
                return "fourChannels";
            }
        }
        throw new IllegalArgumentException("Unsupported number of channels: " + numberChannels);
    }

    private IdentifierHelper() {
    }
}

