/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.stackwriter;

import java.nio.file.Path;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.test.image.rasterwriter.comparison.ComparisonPlan;
import org.anchoranalysis.test.image.stackwriter.FourChannelStackTester;
import org.anchoranalysis.test.image.stackwriter.StackTester;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class StackWriterTestBase {
    protected static final VoxelDataType[] ALL_SUPPORTED_VOXEL_TYPES = new VoxelDataType[]{UnsignedByteVoxelType.INSTANCE, UnsignedShortVoxelType.INSTANCE, UnsignedIntVoxelType.INSTANCE, FloatVoxelType.INSTANCE};
    @TempDir
    public Path directory;
    private final ImageFileFormat format;
    private final boolean include3D;
    private final ComparisonPlan comparisonPlan;
    protected FourChannelStackTester tester;

    @BeforeEach
    void setup() {
        String extension = this.format.getDefaultExtension();
        this.tester = new FourChannelStackTester(new StackTester(this.createWriter(), this.directory, extension, this.include3D), this.comparisonPlan.createComparer(this.directory, extension), this.comparisonPlan.isSkipComparisonForRGB());
    }

    protected abstract StackWriter createWriter();

    public StackWriterTestBase(ImageFileFormat format, boolean include3D, ComparisonPlan comparisonPlan) {
        this.format = format;
        this.include3D = include3D;
        this.comparisonPlan = comparisonPlan;
    }
}

