/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.stackwriter;

import java.io.IOException;
import java.util.Optional;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.test.image.rasterwriter.comparison.ComparisonPlan;
import org.anchoranalysis.test.image.stackwriter.StackWriterTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class TiffTestBase
extends StackWriterTestBase {
    private static final ComparisonPlan COMPARISON_PLAN = new ComparisonPlan(false, Optional.of(ImageFileFormat.OME_TIFF), false);
    private static final VoxelDataType[] SUPPORTED_VOXEL_TYPES = StackWriterTestBase.ALL_SUPPORTED_VOXEL_TYPES;

    protected TiffTestBase() {
        super(ImageFileFormat.TIFF, true, COMPARISON_PLAN);
    }

    @Test
    void testSingleChannel() throws ImageIOException, IOException {
        this.tester.testSingleChannel(SUPPORTED_VOXEL_TYPES);
    }

    void testSingleChannelRGB() throws ImageIOException, IOException {
        this.tester.testSingleChannelRGB();
    }

    @Test
    void testTwoChannels() {
        Assertions.assertThrows(ImageIOException.class, () -> this.tester.testTwoChannels());
    }

    @Test
    void testThreeChannelsSeparate() throws ImageIOException, IOException {
        this.tester.testThreeChannelsSeparate(SUPPORTED_VOXEL_TYPES);
    }

    @Test
    void testThreeChannelsRGB() throws ImageIOException, IOException {
        this.tester.testThreeChannelsRGB();
    }

    @Test
    void testThreeChannelsRGBUnsignedShort() throws ImageIOException, IOException {
        this.tester.testThreeChannelsRGB((VoxelDataType)UnsignedShortVoxelType.INSTANCE);
    }

    @Test
    void testFourChannels() {
        Assertions.assertThrows(ImageIOException.class, () -> this.tester.testFourChannels());
    }
}

