/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import lombok.Generated;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.test.image.ResolutionFixture;

public class ChannelFixture {
    private boolean includeResolution = true;
    public static final Extent SMALL_3D = new Extent(8, 11, 4);
    public static final Extent SMALL_2D = SMALL_3D.flattenZ();
    public static final Extent MEDIUM_3D = new Extent(69, 61, 7);
    public static final Extent MEDIUM_2D = MEDIUM_3D.flattenZ();
    public static final Extent LARGE_3D = new Extent(1031, 2701, 19);
    public static final Extent LARGE_2D = LARGE_3D.flattenZ();

    public static int sumModulo(int x, int y, int z) {
        return ChannelFixture.modulo(x + y + z);
    }

    public static int diffModulo(int x, int y, int z) {
        return ChannelFixture.modulo(x - y - z);
    }

    public static int multModulo(int x, int y, int z) {
        return ChannelFixture.modulo(x * y * z);
    }

    public Channel createChannel(Extent extent, IntensityFunction createIntensity, VoxelDataType channelVoxelType) {
        Dimensions dimensions = this.createDimensions(extent);
        Channel channel = ((ChannelFactorySingleType)ChannelFactory.instance().get(channelVoxelType)).createEmptyInitialised(dimensions);
        IterateVoxelsAll.withVoxelBuffer((Voxels)channel.voxels().any(), (point, buffer, offset) -> buffer.putInt(offset, createIntensity.valueFor(point)));
        return channel;
    }

    private Dimensions createDimensions(Extent extent) {
        return new Dimensions(extent, OptionalFactory.create((boolean)this.includeResolution, () -> ResolutionFixture.INSTANCE));
    }

    private static int modulo(int number) {
        if (number >= 0) {
            return Math.floorMod(number, 256);
        }
        return 0;
    }

    @Generated
    public ChannelFixture() {
    }

    @Generated
    public ChannelFixture(boolean includeResolution) {
        this.includeResolution = includeResolution;
    }

    @FunctionalInterface
    public static interface IntensityFunction {
        default public int valueFor(Point3i point) {
            return this.valueFor(point.x(), point.y(), point.z());
        }

        public int valueFor(int var1, int var2, int var3);
    }
}

