/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.test.TestLoader;
import org.anchoranalysis.test.image.DualComparer;

public class DualComparerFactory {
    public static DualComparer compareExplicitDirectoryToTest(Path pathExplicit, String pathRelativeTestDir) {
        TestLoader loaderTemporary = TestLoader.createFromExplicitDirectory((Path)pathExplicit);
        TestLoader loaderTest = TestLoader.createFromMavenWorkingDirectory((String)pathRelativeTestDir);
        return new DualComparer(loaderTemporary, loaderTest);
    }

    public static DualComparer compareTemporaryDirectoryToTest(Path directory, Optional<String> relativeTemporaryDirectory, String relativeResourcesRoot) {
        TestLoader loaderTemporary = DualComparerFactory.loaderTemporaryDirectory(directory, relativeTemporaryDirectory);
        TestLoader loaderTest = TestLoader.createFromMavenWorkingDirectory((String)relativeResourcesRoot);
        return new DualComparer(loaderTemporary, loaderTest);
    }

    public static DualComparer compareTwoSubdirectoriesInLoader(TestLoader loader, String subdirectory1, String subdirectory2) {
        return new DualComparer(loader.createForSubdirectory(subdirectory1), loader.createForSubdirectory(subdirectory2));
    }

    public static DualComparer compareTwoSubdirectoriesInLoader(TestLoader loader1, String subdirectory1, TestLoader loader2, String subdirectory2) {
        return new DualComparer(loader1.createForSubdirectory(subdirectory1), loader2.createForSubdirectory(subdirectory2));
    }

    private static TestLoader loaderTemporaryDirectory(Path directory, Optional<String> additionalRelative) {
        Path directoryAbsolute = directory.toAbsolutePath();
        Path pathTemporary = additionalRelative.map(directoryAbsolute::resolve).orElseGet(() -> directoryAbsolute);
        return TestLoader.createFromExplicitDirectory((Path)pathTemporary);
    }

    @Generated
    private DualComparerFactory() {
    }
}

