/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.test.LoggerFixture;

public class InputOutputContextFixture {
    public static InputOutputContext withSuppressedLogger(Path modelDir) {
        return new ContextFromLogger(LoggerFixture.suppressedLogger(), modelDir);
    }

    public static InputOutputContext withSuppressedLogger() {
        return InputOutputContextFixture.withLogger(LoggerFixture.suppressedLogger());
    }

    public static InputOutputContext withLogger(Logger logger) {
        return new ContextFromLogger(logger, Paths.get("", new String[0]));
    }

    @Generated
    private InputOutputContextFixture() {
    }

    private static class ContextFromLogger
    implements InputOutputContext {
        private final Logger logger;
        private final Path modelDirectory;

        public Logger getLogger() {
            return this.logger;
        }

        public Path getModelDirectory() {
            return this.modelDirectory;
        }

        public Outputter getOutputter() {
            throw new AnchorImpossibleSituationException();
        }

        public boolean isDebugEnabled() {
            throw new AnchorImpossibleSituationException();
        }

        public ExecutionTimeRecorder getExecutionTimeRecorder() {
            throw new AnchorImpossibleSituationException();
        }

        @Generated
        public ContextFromLogger(Logger logger, Path modelDirectory) {
            this.logger = logger;
            this.modelDirectory = modelDirectory;
        }
    }
}

