/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image;

import io.vavr.control.Either;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.core.index.SetOperationFailedException;
import org.anchoranalysis.image.bean.displayer.IntensityQuantiles;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.object.output.mask.ObjectAsMaskGenerator;
import org.anchoranalysis.image.io.object.output.rgb.DrawObjectsGenerator;
import org.anchoranalysis.image.io.stack.output.generator.DisplayStackGenerator;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.generator.Generator;
import org.anchoranalysis.io.generator.collection.CollectionGenerator;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.BindFailedException;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.spatial.box.BoundedList;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.test.image.io.OutputterFixture;

public class WriteIntoDirectory {
    private static final StackDisplayer DISPLAYER = new IntensityQuantiles();
    private static final Dimensions FALLBACK_SIZE = new Dimensions(100, 100, 1);
    private final Path directory;
    private final boolean printDirectoryToConsole;
    private Outputter outputter;
    private DisplayStackGenerator generatorStack = new DisplayStackGenerator(false);
    private ObjectAsMaskGenerator generatorSingleObject = new ObjectAsMaskGenerator();

    public WriteIntoDirectory(Path directory) {
        this.printDirectoryToConsole = true;
        this.directory = directory;
    }

    public void writeStack(String outputName, DisplayStack stack) {
        this.setupOutputterIfNecessary();
        this.outputter.writerPermissive().write(outputName, () -> this.generatorStack, () -> stack);
    }

    public void writeObject(String outputName, ObjectMask object) throws SetOperationFailedException {
        this.setupOutputterIfNecessary();
        this.outputter.writerPermissive().write(outputName, () -> this.generatorSingleObject, () -> object);
    }

    public void writeObjects(String outputName, ObjectCollection objects) {
        Dimensions dimensionsResolved = WriteIntoDirectory.dimensionsToCenterObjects(objects);
        this.writeObjectsEither(outputName, objects, (Either<Dimensions, DisplayStack>)Either.left((Object)dimensionsResolved));
    }

    public void writeObjects(String outputName, ObjectCollection objects, Stack background) {
        this.writeObjectsEither(outputName, objects, (Either<Dimensions, DisplayStack>)Either.right((Object)WriteIntoDirectory.displayStackFor(background)));
    }

    public void writeVoxels(String outputName, Voxels<UnsignedByteBuffer> voxels) {
        Channel channel = ChannelFactory.instance().create(voxels);
        this.writeChannel(outputName, channel);
    }

    public void writeChannel(String outputName, Channel channel) {
        this.setupOutputterIfNecessary();
        this.writeStack(outputName, WriteIntoDirectory.displayStackFor(channel));
    }

    public void writeList(String outputName, List<DisplayStack> stacks, boolean always2D) throws OutputWriteFailedException {
        this.setupOutputterIfNecessary();
        this.outputter.getChecked().getWriters().permissive().write(outputName, () -> new CollectionGenerator((Generator)this.generatorStack, outputName), () -> stacks);
    }

    private static DisplayStack displayStackFor(Channel channel) {
        try {
            return DISPLAYER.deriveFrom(channel);
        }
        catch (CreateException e) {
            throw new AnchorFriendlyRuntimeException((Throwable)e);
        }
    }

    private static DisplayStack displayStackFor(Stack stack) {
        try {
            return DISPLAYER.deriveFrom(stack);
        }
        catch (CreateException e) {
            throw new AnchorFriendlyRuntimeException((Throwable)e);
        }
    }

    private void setupOutputterIfNecessary() {
        try {
            if (this.outputter == null) {
                this.outputter = OutputterFixture.outputter(Optional.of(this.directory));
                if (this.printDirectoryToConsole) {
                    System.out.println("Outputs written in test to: " + String.valueOf(this.directory));
                }
            }
        }
        catch (BindFailedException e) {
            throw new AnchorFriendlyRuntimeException((Throwable)e);
        }
    }

    private void writeObjectsEither(String outputName, ObjectCollection objects, Either<Dimensions, DisplayStack> background) {
        this.setupOutputterIfNecessary();
        DrawObjectsGenerator generatorObjects = DrawObjectsGenerator.outlineVariedColors((int)objects.size(), (int)1, background);
        this.outputter.writerPermissive().write(outputName, () -> generatorObjects, () -> new ObjectCollectionWithProperties(objects));
    }

    private static Dimensions dimensionsToCenterObjects(ObjectCollection objects) {
        if (objects.size() == 0) {
            return FALLBACK_SIZE;
        }
        BoundingBox boxSpans = WriteIntoDirectory.boundingBoxThatSpans(objects);
        BoundingBox boxCentered = boxSpans.changeExtent(boxSpans.extent().growBy(boxSpans.cornerMin()));
        return new Dimensions(boxCentered.calculateCornerMaxExclusive());
    }

    private static BoundingBox boundingBoxThatSpans(ObjectCollection objects) {
        return BoundedList.createFromList((List)objects.asList(), ObjectMask::boundingBox).boundingBox();
    }

    @Generated
    public WriteIntoDirectory(Path directory, boolean printDirectoryToConsole) {
        this.directory = directory;
        this.printDirectoryToConsole = printDirectoryToConsole;
    }

    @Generated
    public Path getDirectory() {
        return this.directory;
    }
}

