/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.csv;

import java.io.PrintStream;
import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.io.input.csv.CSVReader;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.test.image.csv.CompareSorted;
import org.anchoranalysis.test.image.csv.CompareUnsorted;
import org.anchoranalysis.test.image.csv.CompareUtilities;
import org.apache.commons.lang.ArrayUtils;

public class CSVComparer {
    private String regExSeperator;
    private boolean firstLineHeaders;
    private int ignoreFirstNumberColumns;
    private boolean sortLines;
    private boolean rejectZeroRows;

    public boolean areCSVFilesEqual(Path path1, Path path2, PrintStream messageStream) throws CSVReaderException {
        try (CSVReader.OpenedCSVFile file1 = this.openCSVFromFilePath(path1);){
            boolean bl;
            block20: {
                CSVReader.OpenedCSVFile file2;
                block18: {
                    boolean bl2;
                    block19: {
                        block16: {
                            boolean bl3;
                            block17: {
                                file2 = this.openCSVFromFilePath(path2);
                                try {
                                    if (!this.firstLineHeaders || CSVComparer.checkHeadersIdentical(file1, file2, messageStream)) break block16;
                                    bl3 = false;
                                    if (file2 == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (file2 != null) {
                                        try {
                                            file2.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                file2.close();
                            }
                            return bl3;
                        }
                        if (!this.sortLines) break block18;
                        CompareSorted compareWithSorting = new CompareSorted(this.ignoreFirstNumberColumns, this.rejectZeroRows);
                        bl2 = compareWithSorting.compare(file1, file2, System.out);
                        if (file2 == null) break block19;
                        file2.close();
                    }
                    return bl2;
                }
                CompareUnsorted compareUnsorted = new CompareUnsorted();
                bl = compareUnsorted.compareCsvFilesWithoutSorting(file1, file2, this.ignoreFirstNumberColumns, this.rejectZeroRows);
                if (file2 == null) break block20;
                file2.close();
            }
            return bl;
        }
    }

    private static boolean checkHeadersIdentical(CSVReader.OpenedCSVFile file1, CSVReader.OpenedCSVFile file2, PrintStream messageStream) {
        String[] headers2;
        String[] headers1 = file1.getHeaders();
        if (ArrayUtils.isEquals((Object)headers1, (Object)(headers2 = file2.getHeaders()))) {
            return true;
        }
        messageStream.println("Headers are not identical:");
        CompareUtilities.printTwoLines(messageStream, headers1, headers2);
        return false;
    }

    private CSVReader.OpenedCSVFile openCSVFromFilePath(Path filePath) throws CSVReaderException {
        CSVReader csvReader = new CSVReader(this.regExSeperator, this.firstLineHeaders);
        return csvReader.read(filePath);
    }

    @Generated
    public CSVComparer(String regExSeperator, boolean firstLineHeaders, int ignoreFirstNumberColumns, boolean sortLines, boolean rejectZeroRows) {
        this.regExSeperator = regExSeperator;
        this.firstLineHeaders = firstLineHeaders;
        this.ignoreFirstNumberColumns = ignoreFirstNumberColumns;
        this.sortLines = sortLines;
        this.rejectZeroRows = rejectZeroRows;
    }
}

