/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.csv;

import java.io.PrintStream;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

class CompareUtilities {
    public static void checkZeroRows(boolean rejectZeroRows, Optional<String[]> lines1, Optional<String[]> lines2) throws CSVReaderException {
        if (!(!rejectZeroRows || lines1.isPresent() && lines2.isPresent())) {
            throw new CSVReaderException("At least one input csv file has zero rows");
        }
    }

    public static boolean areArraysEqual(Optional<String[]> array1, Optional<String[]> array2, int ignoreInitialElements) {
        if (!array1.isPresent()) {
            return !array2.isPresent();
        }
        if (!array2.isPresent()) {
            return !array1.isPresent();
        }
        if (array1.get().length != array2.get().length) {
            return false;
        }
        if (ignoreInitialElements > 0) {
            int maxInd = Math.max(array1.get().length - ignoreInitialElements, 0);
            for (int i = ignoreInitialElements; i < maxInd; ++i) {
                if (array1.get()[i].equals(array2.get()[i])) continue;
                return false;
            }
            return true;
        }
        return ArrayUtils.isEquals((Object)array1.get(), (Object)array2.get());
    }

    public static void printTwoLines(PrintStream messageStream, String[] line1, String[] line2) {
        CompareUtilities.printTwoLines(messageStream, line1, line2, "  ");
    }

    public static void printTwoLines(PrintStream messageStream, String[] line1, String[] line2, String delimeter) {
        StringBuilder out1 = new StringBuilder();
        StringBuilder out2 = new StringBuilder();
        if (line1.length != line2.length) {
            throw new IllegalArgumentException("line1 and line2 have a different number of elements");
        }
        for (int i = 0; i < line1.length; ++i) {
            if (i != 0) {
                out1.append(delimeter);
                out2.append(delimeter);
            }
            String elem1 = line1[i];
            String elem2 = line2[i];
            int maxLength = Integer.max(elem1.length(), elem2.length());
            out1.append(StringUtils.rightPad((String)elem1, (int)maxLength));
            out2.append(StringUtils.rightPad((String)elem2, (int)maxLength));
        }
        messageStream.println(out1.toString());
        messageStream.println(out2.toString());
    }

    @Generated
    private CompareUtilities() {
    }
}

