/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.io;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.serialize.DeserializationFailedException;
import org.anchoranalysis.core.time.ExecutionTimeRecorderIgnore;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.object.input.ObjectCollectionReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.io.bioformats.ConfigureBioformatsLogging;
import org.anchoranalysis.test.LoggerFixture;
import org.anchoranalysis.test.TestDataLoadException;
import org.anchoranalysis.test.TestLoader;
import org.anchoranalysis.test.image.io.BeanInstanceMapFixture;

public class TestLoaderImage {
    private final TestLoader loader;
    private final StackReader stackReader;
    private final Logger logger = LoggerFixture.suppressedLogger();

    public TestLoaderImage(TestLoader loader) {
        this.loader = loader;
        this.stackReader = BeanInstanceMapFixture.ensureStackReader();
    }

    public Channel openChannelFromTestPath(String testPath) {
        return TestLoaderImage.extractChannel(this.openStackFromTestPath(testPath));
    }

    public Channel openChannelFromFilePath(Path filePath) {
        return TestLoaderImage.extractChannel(this.openStackFromFilePath(filePath));
    }

    public Stack openStackFromTestPath(String testPath) {
        ConfigureBioformatsLogging.instance().makeSureConfigured();
        Path filePath = this.loader.resolveTestPath(testPath);
        return this.openStackFromFilePath(filePath);
    }

    public Stack openStackFromFilePath(Path filePath) {
        Stack stack;
        block8: {
            ConfigureBioformatsLogging.instance().makeSureConfigured();
            OpenedImageFile openedFile = this.stackReader.openFile(filePath, ExecutionTimeRecorderIgnore.instance());
            try {
                stack = openedFile.open(this.logger).getFrame(0);
                if (openedFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (openedFile != null) {
                        try {
                            openedFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ImageIOException e) {
                    throw new TestDataLoadException((Throwable)e);
                }
            }
            openedFile.close();
        }
        return stack;
    }

    public boolean compareTwoImages(String path1, String path2) throws FileNotFoundException {
        return TestLoaderImage.compareTwoImages(this, path1, this, path2, false);
    }

    public static boolean compareTwoImages(TestLoaderImage loader1, String path1, TestLoaderImage loader2, String path2, boolean ignoreResolutionDifferences) throws FileNotFoundException {
        if (!loader1.doesPathExist(path1)) {
            throw new FileNotFoundException(path1);
        }
        if (!loader2.doesPathExist(path2)) {
            throw new FileNotFoundException(path2);
        }
        Stack stackWritten = loader1.openStackFromTestPath(path1);
        Stack stackSaved = loader2.openStackFromTestPath(path2);
        return stackWritten.equalsDeep(stackSaved, !ignoreResolutionDifferences);
    }

    public ObjectCollection openObjectsFromTestPath(String testDirectoryPath) {
        Path filePath = this.loader.resolveTestPath(testDirectoryPath);
        return this.openObjectsFromFilePath(filePath);
    }

    public ObjectCollection openObjectsFromFilePath(Path folderPath) {
        ConfigureBioformatsLogging.instance().makeSureConfigured();
        BeanInstanceMapFixture.ensureStackReader();
        try {
            return ObjectCollectionReader.createFromPath((Path)folderPath, (OperationContext)LoggerFixture.suppressedOperationContext());
        }
        catch (DeserializationFailedException e) {
            throw new TestDataLoadException((Throwable)e);
        }
    }

    public boolean compareTwoObjectCollections(String path1, String path2) {
        if (!this.loader.doesPathExist(path1)) {
            throw new TestDataLoadException(String.format("The first-path cannot be found in the first test-loader: %s", path1));
        }
        if (!this.loader.doesPathExist(path2)) {
            throw new TestDataLoadException(String.format("The second-path cannot be found in the second test-loader: %s", path1));
        }
        ObjectCollection objectsWritten = this.openObjectsFromTestPath(path1);
        ObjectCollection objectsSaved = this.openObjectsFromTestPath(path2);
        return objectsWritten.equalsDeep(objectsSaved);
    }

    public Path resolveTestPath(String testPath) {
        return this.loader.resolveTestPath(testPath);
    }

    public boolean doesPathExist(String testFilePath) {
        return this.loader.doesPathExist(testFilePath);
    }

    private static Channel extractChannel(Stack stack) {
        if (stack.getNumberChannels() != 1) {
            throw new TestDataLoadException("Loading a stack which contains more than one channel, when only one channel is intended");
        }
        return stack.getChannel(0);
    }

    @Generated
    public TestLoaderImage(TestLoader loader, StackReader stackReader) {
        this.loader = loader;
        this.stackReader = stackReader;
    }

    @Generated
    public TestLoader getLoader() {
        return this.loader;
    }
}

