/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.load;

import java.io.File;
import java.nio.file.Path;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.test.TestLoader;
import org.anchoranalysis.test.image.io.TestLoaderImage;

public class CarImageLoader {
    private static final String PATH_SUBDIRECTORY = "car";
    private static final String PATH_CAR = "car.jpg";
    private static final String PATH_CAR_GRAYSCALE_8_BIT = "carGrayscale8bit.jpg";
    private static final String PATH_CAR_GRAYSCALE_16_BIT = "carGrayscale16bit.tif";
    private TestLoaderImage loader = new TestLoaderImage(TestLoader.createFromMavenWorkingDirectory());

    public Stack carRGB() {
        return this.loadFromSubdirectory(PATH_CAR);
    }

    public Stack carGrayscale8Bit() {
        return this.loadFromSubdirectory(PATH_CAR_GRAYSCALE_8_BIT);
    }

    public Stack carGrayscale16Bit() {
        return this.loadFromSubdirectory(PATH_CAR_GRAYSCALE_16_BIT);
    }

    public EnergyStackWithoutParameters carRGBAsEnergy() {
        return new EnergyStackWithoutParameters(this.carRGB());
    }

    public EnergyStackWithoutParameters carGrayscale8BitAsEnergy() {
        return new EnergyStackWithoutParameters(this.carGrayscale8Bit());
    }

    public EnergyStackWithoutParameters carGrayscale16BitAsEnergy() {
        return new EnergyStackWithoutParameters(this.carGrayscale16Bit());
    }

    public Path modelDirectory() {
        return this.loader.getLoader().getRoot();
    }

    private Stack loadFromSubdirectory(String filename) {
        return this.loader.openStackFromTestPath(PATH_SUBDIRECTORY + File.separator + filename);
    }
}

