/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.object;

import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.test.image.object.VoxelPattern;

public class CutOffCorners
implements VoxelPattern {
    private int edgeXY;
    private int edgeZ;
    private Extent rightBorder;

    public CutOffCorners(int edgeXY, int edgeZ, Extent extent) {
        this.edgeXY = edgeXY;
        this.edgeZ = edgeZ;
        this.rightBorder = new Extent(extent.x() - edgeXY - 1, extent.y() - edgeXY - 1, extent.z() - edgeZ - 1);
    }

    @Override
    public boolean isPixelOn(int x, int y, int z) {
        if (x < this.edgeXY) {
            return false;
        }
        if (x > this.rightBorder.x()) {
            return false;
        }
        if (y < this.edgeXY) {
            return false;
        }
        if (y > this.rightBorder.y()) {
            return false;
        }
        if (z < this.edgeZ) {
            return false;
        }
        return z <= this.rightBorder.z();
    }
}

