/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.object;

import java.util.Optional;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.test.image.object.CutOffCorners;
import org.anchoranalysis.test.image.object.VoxelPattern;
import org.junit.jupiter.api.Assertions;

public class CutOffCornersObjectFixture {
    private final Optional<Dimensions> dimensions;

    public CutOffCornersObjectFixture() {
        this.dimensions = Optional.empty();
    }

    public CutOffCornersObjectFixture(Dimensions dimensions) {
        this.dimensions = Optional.of(dimensions);
    }

    public ObjectMask create1() {
        return this.create(new Point3i(10, 15, 3), new Extent(20, 34, 11), 3, 2);
    }

    public ObjectMask create2() {
        return this.create(new Point3i(3, 1, 7), new Extent(19, 14, 5), 5, 1);
    }

    public ObjectMask create3() {
        return this.create(new Point3i(17, 15, 2), new Extent(19, 14, 13), 1, 5);
    }

    public ObjectCollection createAll() {
        return ObjectCollectionFactory.of((ObjectMask[])new ObjectMask[]{this.create1(), this.create2(), this.create3()});
    }

    private ObjectMask create(Point3i corner, Extent extent, int cornerEdgeXY, int cornerEdgeZ) {
        CutOffCorners pattern = new CutOffCorners(cornerEdgeXY, cornerEdgeZ, extent);
        return this.createAt(corner, extent, pattern);
    }

    private ObjectMask createAt(Point3i cornerMin, Extent extent, VoxelPattern pattern) {
        BoundingBox box = BoundingBox.createReuse((ReadableTuple3i)cornerMin, (Extent)extent);
        if (this.dimensions.isPresent()) {
            Assertions.assertTrue((boolean)this.dimensions.get().contains(box));
        }
        Voxels voxels = VoxelsFactory.getUnsignedByte().createInitialized(extent);
        BinaryValuesInt binaryValues = BinaryValuesInt.getDefault();
        BinaryValuesByte binaryValuesByte = binaryValues.asByte();
        boolean atLeastOneHigh = false;
        for (int z = 0; z < extent.z(); ++z) {
            VoxelBuffer slice = voxels.slice(z);
            for (int y = 0; y < extent.y(); ++y) {
                for (int x = 0; x < extent.x(); ++x) {
                    byte toPut;
                    if (pattern.isPixelOn(x, y, z)) {
                        toPut = binaryValuesByte.getOn();
                        atLeastOneHigh = true;
                    } else {
                        toPut = binaryValuesByte.getOff();
                    }
                    slice.putByte(extent.offset(x, y), toPut);
                }
            }
        }
        Assertions.assertTrue((boolean)atLeastOneHigh);
        return new ObjectMask(box, BinaryVoxelsFactory.reuseByte((Voxels)voxels, (BinaryValuesInt)binaryValues));
    }
}

