/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.rasterwriter.comparison;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.test.image.DualComparer;
import org.anchoranalysis.test.image.rasterwriter.comparison.CombineComparers;
import org.anchoranalysis.test.image.rasterwriter.comparison.CompareBytes;
import org.anchoranalysis.test.image.rasterwriter.comparison.CompareVoxels;
import org.anchoranalysis.test.image.rasterwriter.comparison.CopyMissingImages;
import org.anchoranalysis.test.image.rasterwriter.comparison.ImageComparer;
import org.anchoranalysis.test.image.stackwriter.SavedFiles;

public final class ComparisonPlan {
    private final boolean bytewiseCompare;
    private final Optional<ImageFileFormat> formatVoxelwiseCompare;
    private final boolean skipComparisonForRGB;
    private final Optional<String> directoryPathToCopyMissingImagesTo;

    public ComparisonPlan(boolean bytewiseCompare, Optional<ImageFileFormat> formatVoxelwiseCompare, boolean skipComparisonForRGB) {
        this(bytewiseCompare, formatVoxelwiseCompare, skipComparisonForRGB, Optional.empty());
    }

    public ComparisonPlan(boolean bytewiseCompare, Optional<ImageFileFormat> formatVoxelwiseCompare, boolean skipComparisonForRGB, String directoryPathToCopyMissingImagesTo) {
        this(bytewiseCompare, formatVoxelwiseCompare, skipComparisonForRGB, Optional.of(directoryPathToCopyMissingImagesTo));
    }

    public ImageComparer createComparer(Path directory, String extension) {
        return this.maybeCopyMissingImages(new CombineComparers(this.maybeCreateBytewiseComparer(directory, extension), this.maybeCreateVoxelwiseComparer(directory)));
    }

    private ImageComparer maybeCopyMissingImages(ImageComparer comparer) {
        if (this.directoryPathToCopyMissingImagesTo.isPresent()) {
            return new CopyMissingImages(comparer, Paths.get(this.directoryPathToCopyMissingImagesTo.get(), new String[0]));
        }
        return comparer;
    }

    private Optional<ImageComparer> maybeCreateBytewiseComparer(Path directory, String extension) {
        return OptionalFactory.create((boolean)this.bytewiseCompare, () -> new CompareBytes(this.createComparer(extension, directory)));
    }

    private Optional<ImageComparer> maybeCreateVoxelwiseComparer(Path directory) {
        return this.formatVoxelwiseCompare.map(ImageFileFormat::getDefaultExtension).map(extension -> new CompareVoxels(this.createComparer((String)extension, directory), (String)extension));
    }

    private DualComparer createComparer(String extensionForComparer, Path directory) {
        return SavedFiles.createComparer(directory, extensionForComparer);
    }

    @Generated
    public boolean isBytewiseCompare() {
        return this.bytewiseCompare;
    }

    @Generated
    public Optional<ImageFileFormat> getFormatVoxelwiseCompare() {
        return this.formatVoxelwiseCompare;
    }

    @Generated
    public boolean isSkipComparisonForRGB() {
        return this.skipComparisonForRGB;
    }

    @Generated
    public Optional<String> getDirectoryPathToCopyMissingImagesTo() {
        return this.directoryPathToCopyMissingImagesTo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComparisonPlan)) {
            return false;
        }
        ComparisonPlan other = (ComparisonPlan)o;
        if (this.isBytewiseCompare() != other.isBytewiseCompare()) {
            return false;
        }
        if (this.isSkipComparisonForRGB() != other.isSkipComparisonForRGB()) {
            return false;
        }
        Optional<ImageFileFormat> this$formatVoxelwiseCompare = this.getFormatVoxelwiseCompare();
        Optional<ImageFileFormat> other$formatVoxelwiseCompare = other.getFormatVoxelwiseCompare();
        if (this$formatVoxelwiseCompare == null ? other$formatVoxelwiseCompare != null : !((Object)this$formatVoxelwiseCompare).equals(other$formatVoxelwiseCompare)) {
            return false;
        }
        Optional<String> this$directoryPathToCopyMissingImagesTo = this.getDirectoryPathToCopyMissingImagesTo();
        Optional<String> other$directoryPathToCopyMissingImagesTo = other.getDirectoryPathToCopyMissingImagesTo();
        return !(this$directoryPathToCopyMissingImagesTo == null ? other$directoryPathToCopyMissingImagesTo != null : !((Object)this$directoryPathToCopyMissingImagesTo).equals(other$directoryPathToCopyMissingImagesTo));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBytewiseCompare() ? 79 : 97);
        result = result * 59 + (this.isSkipComparisonForRGB() ? 79 : 97);
        Optional<ImageFileFormat> $formatVoxelwiseCompare = this.getFormatVoxelwiseCompare();
        result = result * 59 + ($formatVoxelwiseCompare == null ? 43 : ((Object)$formatVoxelwiseCompare).hashCode());
        Optional<String> $directoryPathToCopyMissingImagesTo = this.getDirectoryPathToCopyMissingImagesTo();
        result = result * 59 + ($directoryPathToCopyMissingImagesTo == null ? 43 : ((Object)$directoryPathToCopyMissingImagesTo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComparisonPlan(bytewiseCompare=" + this.isBytewiseCompare() + ", formatVoxelwiseCompare=" + String.valueOf(this.getFormatVoxelwiseCompare()) + ", skipComparisonForRGB=" + this.isSkipComparisonForRGB() + ", directoryPathToCopyMissingImagesTo=" + String.valueOf(this.getDirectoryPathToCopyMissingImagesTo()) + ")";
    }

    @Generated
    private ComparisonPlan(boolean bytewiseCompare, Optional<ImageFileFormat> formatVoxelwiseCompare, boolean skipComparisonForRGB, Optional<String> directoryPathToCopyMissingImagesTo) {
        this.bytewiseCompare = bytewiseCompare;
        this.formatVoxelwiseCompare = formatVoxelwiseCompare;
        this.skipComparisonForRGB = skipComparisonForRGB;
        this.directoryPathToCopyMissingImagesTo = directoryPathToCopyMissingImagesTo;
    }
}

